/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.ofdconverter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ofdconverter.DocConverter;
import org.ofdrw.layout.OFDDoc;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.element.Paragraph;

public class TextConverter
implements DocConverter {
    final OFDDoc ofdDoc;
    double fontSize = 3.0;
    private boolean closed = false;

    public TextConverter(Path ofdPath) throws IOException {
        if (ofdPath == null) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684OFD\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(ofdPath = ofdPath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = ofdPath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(ofdPath, new FileAttribute[0]);
        }
        this.ofdDoc = new OFDDoc(ofdPath);
    }

    public TextConverter(OutputStream output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684OFD\u6d41\u4e3a\u7a7a");
        }
        this.ofdDoc = new OFDDoc(output);
    }

    @Override
    public void convert(Path filepath, int ... indexes) throws GeneralConvertException {
        if (filepath == null || !Files.exists(filepath, new LinkOption[0]) || Files.isDirectory(filepath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(filepath.toFile()));){
            String line;
            while ((line = br.readLine()) != null) {
                Paragraph p = new Paragraph(line, (Double)this.fontSize);
                this.ofdDoc.add(p);
            }
        }
        catch (IOException e) {
            throw new GeneralConvertException("\u6587\u672c\u8f6c\u6362OFD\u5f02\u5e38", e);
        }
    }

    public void append(String txt) {
        Paragraph p = new Paragraph(txt, (Double)this.fontSize);
        this.ofdDoc.add(p);
    }

    public void setPageSize(PageLayout pageLayout) {
        this.ofdDoc.setDefaultPageLayout(pageLayout);
    }

    public void setFontSize(double fontSize) {
        if (fontSize <= 0.0) {
            fontSize = 3.0;
        }
        this.fontSize = fontSize;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdDoc != null) {
            this.ofdDoc.close();
        }
    }
}

