/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.type1.Type1Font;
import org.ofdrw.converter.font.CmapSubtable;
import org.ofdrw.converter.font.FontDrawPathProvider;
import org.ofdrw.converter.font.GlyphData;
import org.ofdrw.converter.font.GlyphDataProvider;
import org.ofdrw.converter.font.HorizontalHeaderTable;
import org.ofdrw.converter.font.HorizontalMetricsTable;
import org.ofdrw.converter.font.MemoryTTFDataStream;
import org.ofdrw.converter.font.NamingTable;
import org.ofdrw.converter.font.TTFDataStream;
import org.ofdrw.converter.font.type1.Type1SegSplitParser;

public class TrueTypeFont
implements GlyphDataProvider,
FontDrawPathProvider {
    private int numGlyphs;
    private long[] glyphOffsets;
    private GlyphData[] glyphs;
    private TTFDataStream data;
    private long[] glyOffset;
    private CmapSubtable[] cmaps;
    private float unitsPerEm;
    public String fontFamily = null;
    public String fontSubFamily = null;
    public String psName = null;
    private HorizontalMetricsTable hmt;
    private CFFFont cffFont;
    private Type1Font type1Font;

    public TrueTypeFont parse(InputStream in) throws IOException {
        byte[] buf = IOUtils.toByteArray(in);
        MemoryTTFDataStream dataStream = new MemoryTTFDataStream(buf);
        return new TrueTypeFont().parse(dataStream);
    }

    public TrueTypeFont parse(byte[] buf) throws IOException {
        MemoryTTFDataStream dataStream = new MemoryTTFDataStream(buf);
        return new TrueTypeFont().parse(dataStream);
    }

    public TrueTypeFont parse(Path inPath) throws IOException {
        MemoryTTFDataStream dataStream = new MemoryTTFDataStream(Files.newInputStream(inPath, new OpenOption[0]));
        return new TrueTypeFont().parse(dataStream);
    }

    public TrueTypeFont parse(TTFDataStream raf) throws IOException {
        this.data = raf;
        byte[] version = raf.read(4);
        if (Type1SegSplitParser.isType1(version)) {
            this.type1Font = Type1SegSplitParser.parse(raf.getOriginalData());
            return this;
        }
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        HashMap<String, long[]> tables = new HashMap<String, long[]>(numberOfTables);
        for (int i = 0; i < numberOfTables; ++i) {
            String tag = raf.readString(4);
            long checkSum = raf.readUnsignedInt();
            long offset = raf.readUnsignedInt();
            long length = raf.readUnsignedInt();
            tables.put(tag, new long[]{offset, length});
        }
        if (!tables.containsKey("head")) {
            InputStream originalData = raf.getOriginalData();
            List<CFFFont> fonts = new CFFParser().parse(IOUtils.toByteArray(originalData));
            if (fonts != null && !fonts.isEmpty()) {
                this.cffFont = fonts.get(0);
                return this;
            }
            throw new IllegalArgumentException("\u6ca1\u6709 head \u8868");
        }
        raf.seek(((long[])tables.get("head"))[0] + 18L);
        this.unitsPerEm = this.data.readUnsignedShort();
        raf.seek(((long[])tables.get("head"))[0] + 50L);
        short indexToLocFormat = raf.readSignedShort();
        if (!tables.containsKey("maxp")) {
            throw new IllegalArgumentException("\u6ca1\u6709 maxp \u8868");
        }
        raf.seek(((long[])tables.get("maxp"))[0] + 4L);
        this.numGlyphs = raf.readUnsignedShort();
        if (!tables.containsKey("loca")) {
            throw new IllegalArgumentException("\u6ca1\u6709 loca \u8868");
        }
        raf.seek(((long[])tables.get("loca"))[0]);
        this.glyphOffsets = new long[this.numGlyphs + 1];
        for (int i = 0; i < this.numGlyphs + 1; ++i) {
            this.glyphOffsets[i] = indexToLocFormat == 0 ? (long)raf.readUnsignedShort() * 2L : raf.readUnsignedInt();
        }
        if (!tables.containsKey("glyf")) {
            throw new IllegalArgumentException("\u6ca1\u6709 glyf \u8868");
        }
        this.glyphs = new GlyphData[this.numGlyphs + 1];
        this.glyOffset = (long[])tables.get("glyf");
        if (tables.containsKey("cmap")) {
            this.cmaps = this.readCMap(((long[])tables.get("cmap"))[0], raf);
        }
        if (tables.containsKey("name")) {
            NamingTable nt = new NamingTable((long[])tables.get("name")).read(raf);
            this.fontFamily = nt.getFontFamily();
            this.fontSubFamily = nt.getFontSubFamily();
            this.psName = nt.getPostScriptName();
            nt = null;
        }
        if (tables.containsKey("hhea") && tables.containsKey("hmtx")) {
            long[] hhOff = (long[])tables.get("hhea");
            long[] hmOff = (long[])tables.get("hmtx");
            int numberOfHMetrics = new HorizontalHeaderTable(hhOff).parse(this.data).getNumberOfHMetrics();
            this.hmt = new HorizontalMetricsTable(hmOff).parse(numberOfHMetrics, this.numGlyphs, this.data);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlyphData getGlyph(int gid) throws IOException {
        if (gid < 0 || gid >= this.numGlyphs) {
            return null;
        }
        if (this.cffFont != null) {
            return null;
        }
        if (this.glyphs != null && this.glyphs[gid] != null) {
            return this.glyphs[gid];
        }
        TTFDataStream tTFDataStream = this.data;
        synchronized (tTFDataStream) {
            GlyphData glyph;
            if (this.glyphOffsets[gid] == this.glyphOffsets[gid + 1]) {
                glyph = new GlyphData();
            } else {
                long currentPosition = this.data.getCurrentPosition();
                this.data.seek(this.glyOffset[0] + this.glyphOffsets[gid]);
                glyph = this.getGlyphData(this.data, gid);
                this.data.seek(currentPosition);
            }
            if (this.glyphs != null && this.glyphs[gid] == null) {
                this.glyphs[gid] = glyph;
            }
            return glyph;
        }
    }

    @Override
    public GeneralPath getPath(int gid) throws IOException {
        if (this.cffFont != null) {
            return this.cffFont.getType2CharString(gid).getPath();
        }
        return this.getGlyph(gid).getPath();
    }

    private GlyphData getGlyphData(TTFDataStream raf, int gid) throws IOException {
        GlyphData glyph = new GlyphData();
        int leftSideBearing = this.hmt == null ? 0 : this.hmt.getLeftSideBearing(gid);
        glyph.readData(raf, leftSideBearing, this);
        if (glyph.getDescription().isComposite()) {
            glyph.getDescription().resolve();
        }
        return glyph;
    }

    public CmapSubtable[] readCMap(long cmapOffset, TTFDataStream data) throws IOException {
        int i;
        data.seek(cmapOffset);
        int version = data.readUnsignedShort();
        int numberOfTables = data.readUnsignedShort();
        CmapSubtable[] cmaps = new CmapSubtable[numberOfTables];
        for (i = 0; i < numberOfTables; ++i) {
            cmaps[i] = new CmapSubtable().initData(data);
        }
        for (i = 0; i < numberOfTables; ++i) {
            cmaps[i].initSubtable(cmapOffset, this.numGlyphs, data);
        }
        return cmaps;
    }

    public CmapSubtable getSubtable(int platformId, int platformEncodingId) {
        if (this.cmaps == null || this.cmaps.length == 0) {
            return null;
        }
        for (CmapSubtable cmap : this.cmaps) {
            if (cmap.getPlatformId() != platformId || cmap.getPlatformEncodingId() != platformEncodingId) continue;
            return cmap;
        }
        return null;
    }

    public CmapLookup getUnicodeCmapLookup() {
        if (this.cmaps == null || this.cmaps.length == 0) {
            throw new IllegalArgumentException("\u5b57\u4f53\u4e2d\u6ca1\u6709cmap");
        }
        CmapSubtable cmap = this.getSubtable(0, 4);
        if (cmap == null) {
            cmap = this.getSubtable(3, 10);
        }
        if (cmap == null) {
            cmap = this.getSubtable(0, 3);
        }
        if (cmap == null) {
            cmap = this.getSubtable(3, 1);
        }
        if (cmap == null) {
            cmap = this.getSubtable(3, 0);
        }
        if (cmap == null) {
            cmap = this.cmaps[0];
        }
        return cmap;
    }

    public GlyphData getUnicodeGlyph(int code) throws IOException {
        int gid = this.cmaps == null || this.cmaps.length == 0 ? 0 : this.getUnicodeCmapLookup().getGlyphId(code);
        return this.getGlyph(gid);
    }

    public List<Number> getFontMatrix() {
        if (this.cffFont != null) {
            return this.cffFont.getFontMatrix();
        }
        float scale = 1000.0f / this.unitsPerEm;
        return Arrays.asList(Float.valueOf(0.001f * scale), 0, 0, Float.valueOf(0.001f * scale), 0, 0);
    }
}

