/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.apache.fontbox.ttf.GlyphDescription;
import org.apache.fontbox.util.BoundingBox;
import org.ofdrw.converter.font.GlyfCompositeDescript;
import org.ofdrw.converter.font.GlyfDescript;
import org.ofdrw.converter.font.GlyfSimpleDescript;
import org.ofdrw.converter.font.GlyphDataProvider;
import org.ofdrw.converter.font.GlyphRenderer;
import org.ofdrw.converter.font.TTFDataStream;

public class GlyphData {
    private short xMin;
    private short yMin;
    private short xMax;
    private short yMax;
    private BoundingBox boundingBox = null;
    private short numberOfContours;
    private GlyfDescript glyphDescription = new GlyfSimpleDescript();

    public GlyphData() {
        this.boundingBox = new BoundingBox();
    }

    public void readData(TTFDataStream data, int leftSideBearing, GlyphDataProvider provider) throws IOException {
        this.numberOfContours = data.readSignedShort();
        this.xMin = data.readSignedShort();
        this.yMin = data.readSignedShort();
        this.xMax = data.readSignedShort();
        this.yMax = data.readSignedShort();
        this.boundingBox = new BoundingBox(this.xMin, this.yMin, this.xMax, this.yMax);
        if (this.numberOfContours >= 0) {
            short x0 = (short)(leftSideBearing - this.xMin);
            this.glyphDescription = new GlyfSimpleDescript(this.numberOfContours, data, x0);
        } else {
            this.glyphDescription = new GlyfCompositeDescript(data, provider);
        }
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBoxValue) {
        this.boundingBox = boundingBoxValue;
    }

    public short getNumberOfContours() {
        return this.numberOfContours;
    }

    public void setNumberOfContours(short numberOfContoursValue) {
        this.numberOfContours = numberOfContoursValue;
    }

    public GlyphDescription getDescription() {
        return this.glyphDescription;
    }

    public GeneralPath getPath() {
        return new GlyphRenderer(this.glyphDescription).getPath();
    }

    public short getXMaximum() {
        return this.xMax;
    }

    public short getXMinimum() {
        return this.xMin;
    }

    public short getYMaximum() {
        return this.yMax;
    }

    public short getYMinimum() {
        return this.yMin;
    }
}

