/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.ofdrw.converter.AWTMaker;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGMaker
extends AWTMaker {
    public SVGMaker(OFDReader reader, int ppm) {
        super(reader, ppm);
    }

    public SVGMaker(OFDReader reader, double ppm) {
        super(reader, ppm);
    }

    public String makePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            throw new GeneralConvertException(String.format("%s \u4e0d\u662f\u6709\u6548\u7d22\u5f15", pageIndex));
        }
        PageInfo pageInfo = (PageInfo)this.pages.get(pageIndex);
        ST_Box pageBox = pageInfo.getSize();
        int pageWidthPixel = (int)Math.round(this.ppm * pageBox.getWidth());
        int pageHeightPixel = (int)Math.round(this.ppm * pageBox.getHeight());
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.setSVGCanvasSize(new Dimension(pageWidthPixel, pageHeightPixel));
        this.writePage(svgGenerator, pageInfo, null);
        boolean useCSS = false;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
            svgGenerator.stream(out, useCSS);
            return outputStream.toString();
        }
        catch (SVGGraphics2DIOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Composite getStampComposite() {
        return AlphaComposite.getInstance(10, this.config.getStampOpacity());
    }
}

