/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.ofdrw.converter.AWTMaker;
import org.ofdrw.converter.SVGMaker;
import org.ofdrw.converter.html.Element;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.text.Weight;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.model.AnnotionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlMaker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Document doc;
    private final OFDReader ofdReader;
    private int screenWidth = 1000;
    private Path outputPath;
    private float scale;

    @Deprecated
    public HtmlMaker(OFDReader ofdReader, String outputFile, int screenWidth) {
        this.ofdReader = ofdReader;
        this.screenWidth = screenWidth;
        if (outputFile == null || "".equals(outputFile)) {
            throw new IllegalArgumentException("\u8f93\u51fa\u8def\u5f84\u4e3a\u7a7a");
        }
        this.outputPath = Paths.get(outputFile, new String[0]).toAbsolutePath();
        if (!Files.exists(this.outputPath, new LinkOption[0])) {
            Path parent = this.outputPath.getParent();
            try {
                if (Files.exists(parent, new LinkOption[0])) {
                    if (!Files.isDirectory(parent, new LinkOption[0])) {
                        throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                    }
                } else {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.createFile(this.outputPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public HtmlMaker(OFDReader ofdReader, Path outputPath, int screenWidth) throws IOException {
        this.ofdReader = ofdReader;
        this.outputPath = outputPath;
        this.screenWidth = screenWidth;
        if (outputPath.toString().equals("")) {
            throw new IllegalArgumentException("\u8f93\u51fa\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(outputPath = outputPath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = outputPath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(outputPath, new FileAttribute[0]);
        }
    }

    public HtmlMaker(OFDReader ofdReader, int screenWidth) throws IOException {
        this.ofdReader = ofdReader;
        this.screenWidth = screenWidth;
    }

    public void writeToFile(String filepath, String content) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filepath));){
            bufferedWriter.write(content);
            bufferedWriter.flush();
        }
    }

    public void parse() {
        if (this.outputPath == null) {
            System.err.println("\u6ca1\u6709\u8bbe\u7f6e\u8f93\u51fa\u8def\u5f84");
            return;
        }
        int pageNum = 1;
        ArrayList<Element> pageDivs = new ArrayList<Element>();
        double paperWidth = 210.0;
        double paperPixels = this.screenWidth;
        ArrayList<ST_Box> boxs = new ArrayList<ST_Box>();
        for (PageInfo pageInfo : this.ofdReader.getPageList()) {
            long start = System.currentTimeMillis();
            ST_Box pageBox = pageInfo.getSize();
            paperWidth = pageBox.getWidth();
            this.scale = (float)Math.round((double)(this.screenWidth - 10) / pageBox.getWidth() * 10.0) / 10.0f;
            int pageWidthPixel = (int)this.converterDpi(pageBox.getWidth());
            int pageHeightPixel = (int)this.converterDpi(pageBox.getHeight());
            paperPixels = pageWidthPixel;
            ST_Box st_box = new ST_Box(0.0, 0.0, pageWidthPixel, pageHeightPixel);
            boxs.add(st_box);
            Element pageDiv = new Element();
            pageDiv.setTagName("div");
            pageDiv.setAttribute("style", String.format("margin-bottom: 20px;position: relative;width:%dpx;height:%dpx;;", pageWidthPixel, pageHeightPixel));
            List<Element> elements = this.makePage(pageInfo);
            for (Element ele : elements) {
                pageDiv.appendChild(ele);
            }
            pageDivs.add(pageDiv);
            long end = System.currentTimeMillis();
            this.logger.info(String.format("page %d speed time %d", pageNum++, end - start));
        }
        double ppm = paperPixels / paperWidth;
        SVGMaker svgMaker = new SVGMaker(this.ofdReader, ppm);
        svgMaker.config.setDrawBoundary(false);
        svgMaker.config.setClip(false);
        ArrayList<String> svgs = new ArrayList<String>();
        for (int i = 0; i < svgMaker.pageSize(); ++i) {
            String svg = svgMaker.makePage(i);
            svgs.add(svg);
        }
        String ofdHtml = this.displayOfdDiv(pageDivs, svgs, boxs);
        try {
            Files.write(this.outputPath, ofdHtml.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String makePageDiv(SVGMaker svgMaker, int index) {
        PageInfo pageInfo = this.ofdReader.getPageInfo(index + 1);
        ST_Box pageBox = pageInfo.getSize();
        this.scale = (float)Math.round((double)(this.screenWidth - 10) / pageBox.getWidth() * 10.0) / 10.0f;
        int pageWidthPixel = (int)this.converterDpi(pageBox.getWidth());
        int pageHeightPixel = (int)this.converterDpi(pageBox.getHeight());
        Element pageDiv = new Element();
        pageDiv.setTagName("div");
        pageDiv.setAttribute("style", String.format("position: absolute;width:%dpx;height:%dpx;", pageWidthPixel, pageHeightPixel));
        List<Element> elements = this.makePage(pageInfo);
        for (Element ele : elements) {
            pageDiv.appendChild(ele);
        }
        double paperWidth = pageBox.getWidth();
        double ppm = (double)pageWidthPixel / paperWidth;
        svgMaker.setPPM(ppm);
        String svg = svgMaker.makePage(index);
        String textLayer = HtmlMaker.ofdElementToXmlNode(pageDiv, null).asXML();
        return String.format("<div style=\"background: white; width: %dpx;height: %dpx;\">%s%s</div>", pageWidthPixel, pageHeightPixel, textLayer, svg);
    }

    private List<Element> makePage(PageInfo pageInfo) {
        List<AnnotionEntity> annotationEntities = this.ofdReader.getAnnotationEntities();
        List<CT_Layer> layerList = pageInfo.getAllLayer();
        List<Element> elements = this.renderLayer(layerList);
        List<Element> elements2 = this.writeAnnoAppearance(pageInfo, annotationEntities);
        elements.addAll(elements2);
        return elements;
    }

    public String displayOfdDiv(List<Element> pageDivs, List<String> svgs, List<ST_Box> boxs) {
        StringBuilder sb = new StringBuilder();
        String svgss = "";
        for (int i = 0; i < svgs.size(); ++i) {
            svgss = svgss + "<div style=\"margin:0 auto;margin-top: 20px;text-align:center;background:white;height:" + boxs.get(i).getHeight() + "px;width:" + boxs.get(i).getWidth() + "px;\" class=\"svgItem\">" + svgs.get(i) + "</div>";
        }
        String title = "\u6587\u4ef6\u9884\u89c8";
        String htmlWrapper = "";
        String prefix = " <!DOCTYPE html>\n                <html lang=\"en\">\n                  <head>\n                    <meta charset=\"utf-8\">\n                    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n                    <meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0\">";
        String titleElement = "<title>" + title + "</title>";
        String ele1 = "</head><body>";
        String svgWrapper = "<div class=\"svgWrapper\"> " + svgss + "</div>";
        String main = "  <div class=\"main-section\"id=\"content\" ref=\"contentDiv\" @mousewheel=\"scrool\">";
        String ele2 = "</div></body></html>";
        String style = "<style>            .svgWrapper {                margin: 0 auto;                left: 0;                right: 0;                text-align: center;                position: absolute;                z-index: 1            }            html,            body {                margin: 0;                background: #808080;                height: 100%            }            .main-section {                padding-top: 20px;                display: flex;                flex-direction: column;                align-items: center;                justify-content: center;                background: #808080;                overflow: hidden;                position: relative;            }          </style>";
        String js = "";
        StringBuilder divs = new StringBuilder();
        for (Element div : pageDivs) {
            org.dom4j.Element element = HtmlMaker.ofdElementToXmlNode(div, null);
            divs.append(element.asXML());
        }
        return sb.append(prefix).append(titleElement).append(ele1).append(svgWrapper).append(main).append((CharSequence)divs).append(ele2).append(style).append(js).toString();
    }

    private List<Element> renderLayer(List<CT_Layer> layerList) {
        ArrayList<Element> pageDivs = new ArrayList<Element>();
        for (CT_Layer layer : layerList) {
            Element pageDiv = new Element();
            pageDiv.setTagName("div");
            List<Element> pageElements = this.writePageBlock(layer.getPageBlocks(), null);
            for (Element ele : pageElements) {
                pageDiv.appendChild(ele);
            }
            pageDivs.add(pageDiv);
        }
        return pageDivs;
    }

    private List<Element> writePageBlock(List<PageBlockType> layerList, ST_Box annotBox) {
        ArrayList<Element> pageElements = new ArrayList<Element>();
        for (PageBlockType block : layerList) {
            if (!(block instanceof TextObject)) continue;
            TextObject textObject = (TextObject)block;
            if (annotBox != null) {
                ST_Box boundary = textObject.getBoundary();
                boundary.setTopLeftX(boundary.getTopLeftX() + annotBox.getTopLeftX());
                boundary.setTopLeftY(boundary.getTopLeftY() + annotBox.getTopLeftY());
                textObject.setBoundary(boundary);
            }
            Element element = this.renderText(textObject);
            pageElements.addAll(new ArrayList<Element>(Collections.singletonList(element)));
        }
        return pageElements;
    }

    private List<Element> writeAnnoAppearance(PageInfo pageInfo, List<AnnotionEntity> annotionEntities) {
        String pageId = pageInfo.getId().toString();
        ArrayList<Element> pageElements = new ArrayList<Element>();
        for (AnnotionEntity annotionEntity : annotionEntities) {
            List<Annot> annotList = annotionEntity.getAnnots();
            if (annotList == null || !pageId.equalsIgnoreCase(annotionEntity.getPageId())) continue;
            for (Annot annot : annotList) {
                List<PageBlockType> pageBlockTypeList = annot.getAppearance().getPageBlocks();
                ST_Box annotBox = annot.getAppearance().getBoundary();
                List<Element> elements = this.writePageBlock(pageBlockTypeList, annotBox);
                pageElements.addAll(elements);
            }
        }
        return pageElements;
    }

    private Element renderText(TextObject textObject) {
        ST_Box boundary = textObject.getBoundary();
        Double hScale = textObject.getHScale();
        Weight fontWeight = textObject.getWeight();
        int fontSize = (int)this.converterDpi(textObject.getSize());
        Double[] ctm = null;
        if (textObject.getCTM() != null && (ctm = textObject.getCTM().toDouble())[0].equals(ctm[3])) {
            fontSize = (int)(ctm[0] * (double)fontSize);
        }
        Element svg = new Element();
        svg.setTagName("svg");
        svg.setNamespaceURI("http://www.w3.org/2000/svg");
        svg.setAttribute("version", "1.1");
        List<TextCode> textCodes = textObject.getTextCodes();
        List<TextCodePoint> textCodePointList = this.calTextPoint(textCodes.get(0));
        for (TextCodePoint textCodePoint : textCodePointList) {
            if (textCodePoint == null || textCodePoint.x == -1.0) continue;
            Element text = new Element();
            text.setTagName("text");
            text.setX(textCodePoint.getX());
            text.setY(textCodePoint.getY());
            text.setInnerHTML(textCodePoint.getText());
            if (ctm != null) {
                if (ctm[0].equals(ctm[3])) {
                    text.setX(textCodePoint.getX() * ctm[0]);
                    text.setY(textCodePoint.getY() * ctm[0]);
                } else {
                    text.setAttribute("transform", String.format("matrix(%s %s %s %s %.2f %.2f)", ctm[0], ctm[1], ctm[2], ctm[3], this.converterDpi(ctm[4]), this.converterDpi(ctm[5])));
                }
            }
            if (hScale != 1.0) {
                // empty if block
            }
            text.setAttribute("fill", "transparent");
            text.setAttribute("style", String.format("font-weight: %d;font-size:%dpx;font-family: %s;%s", fontWeight.getWeight(), fontSize, "simSum", ""));
            svg.appendChild(text);
        }
        svg.setAttribute("style", String.format("overflow:visible;position:absolute;width:%.1fpx;height:%.1fpx;left:%.1fpx;top:%.1fpx;z-index:%s", this.converterDpi(boundary.getWidth()), this.converterDpi(boundary.getHeight()), this.converterDpi(boundary.getTopLeftX()), this.converterDpi(boundary.getTopLeftY()), textObject.getID()));
        return svg;
    }

    private float toFixed2(double num) {
        return (float)Math.round(num * 10.0) / 10.0f;
    }

    private double converterDpi(double num) {
        return CommonUtil.millimetersToPixel(num, this.scale * 25.4f);
    }

    private static org.dom4j.Element ofdElementToXmlNode(Element element, org.dom4j.Element root) {
        List<Element> children;
        if (doc == null || root == null) {
            doc = DocumentHelper.createDocument();
        }
        root = root == null ? doc.addElement(element.getTagName()) : root.addElement(element.getTagName());
        Map<String, String> attribute = element.getAttribute();
        if (attribute != null) {
            for (String name : attribute.keySet()) {
                root.addAttribute(name, attribute.get(name));
            }
        }
        if (element.getInnerHTML() != null) {
            root.setText(element.getInnerHTML());
        }
        if ((children = element.getChildren()) != null) {
            for (Element child : children) {
                HtmlMaker.ofdElementToXmlNode(child, root);
            }
        }
        return root;
    }

    private List<TextCodePoint> calTextPoint(TextCode textCode) {
        double x = 0.0;
        double y = 0.0;
        ArrayList<TextCodePoint> textCodePointList = new ArrayList<TextCodePoint>();
        if (textCode == null) {
            return textCodePointList;
        }
        String textStr = textCode.getText();
        if (textStr == null) {
            return textCodePointList;
        }
        x = textCode.getX();
        y = textCode.getY();
        List<Object> deltaXList = new ArrayList();
        List<Object> deltaYList = new ArrayList();
        if (textCode.getDeltaX() != null && textCode.getDeltaX().getArray() != null) {
            deltaXList = AWTMaker.parseDelta(textCode.getDeltaX());
        }
        if (textCode.getDeltaY() != null && textCode.getDeltaY().getArray() != null) {
            deltaYList = AWTMaker.parseDelta(textCode.getDeltaY());
        }
        for (int i = 0; i < textStr.length(); ++i) {
            int offset;
            if (i > 0 && deltaXList.size() > 0) {
                offset = i - 1;
                if (offset >= deltaXList.size()) {
                    offset = deltaXList.size() - 1;
                }
                x += ((Double)deltaXList.get(offset)).doubleValue();
            }
            if (i > 0 && deltaYList.size() > 0) {
                offset = i - 1;
                if (offset >= deltaYList.size()) {
                    offset = deltaYList.size() - 1;
                }
                y += ((Double)deltaYList.get(offset)).doubleValue();
            }
            String text = textStr.substring(i, i + 1);
            TextCodePoint point = new TextCodePoint(this.converterDpi(x), this.converterDpi(y), text, deltaYList.size() > 0 && deltaXList.size() == 0);
            textCodePointList.add(point);
        }
        return textCodePointList;
    }

    public static boolean isChineseByBlock(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT;
    }

    static class TextCodePoint {
        double x;
        double y;
        String text;
        boolean isVerticalDirection;

        public TextCodePoint() {
        }

        public TextCodePoint(double x, double y, String text, boolean isVerticalDirection) {
            this.x = x;
            this.y = y;
            this.text = text;
            this.isVerticalDirection = isVerticalDirection;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isVerticalDirection() {
            return this.isVerticalDirection;
        }

        public void setVerticalDirection(boolean verticalDirection) {
            this.isVerticalDirection = verticalDirection;
        }
    }
}

