/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendComposite;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendMode;
import org.ofdrw.converter.CGTransformMap;
import org.ofdrw.converter.FontLoader;
import org.ofdrw.converter.ImageMaker;
import org.ofdrw.converter.font.FontWrapper;
import org.ofdrw.converter.font.GlyphData;
import org.ofdrw.converter.font.TrueTypeFont;
import org.ofdrw.converter.point.Tuple2;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.MatrixUtils;
import org.ofdrw.converter.utils.StringUtils;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.annotation.pageannot.Appearance;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.OptVal;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.color.colorSpace.OFDColorSpaceType;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.CT_CGTransform;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.StampAnnotEntity;
import org.ofdrw.reader.tools.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ujmp.core.Matrix;

public abstract class AWTMaker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OFDReader reader;
    protected double ppm = CommonUtil.dpiToPpm(200);
    public final Config config = new Config();
    protected boolean isStamp = false;
    protected List<PageInfo> pages;
    private final ResourceManage resourceManage;
    private final Map<String, FontWrapper<TrueTypeFont>> fontCache = new HashMap<String, FontWrapper<TrueTypeFont>>();

    public AWTMaker(OFDReader reader, int ppm) {
        this.reader = reader;
        this.resourceManage = reader.getResMgt();
        this.pages = reader.getPageList();
        if (this.ppm > 0.0) {
            this.ppm = ppm;
        }
    }

    public AWTMaker(OFDReader reader, double ppm) {
        this.reader = reader;
        this.resourceManage = reader.getResMgt();
        this.pages = reader.getPageList();
        if (this.ppm > 0.0) {
            this.ppm = ppm;
        }
    }

    public int pageSize() {
        return this.pages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStampAnnot(Graphics2D graphics, StampAnnotEntity stampAnnotVo, StampAnnot stampAnnot) {
        BufferedImage stampImage = null;
        graphics = (Graphics2D)graphics.create();
        try (ByteArrayInputStream inputStream = stampAnnotVo.getImageStream();){
            if (stampAnnotVo.getImgType().equals("ofd")) {
                ImageMaker imageMaker = new ImageMaker(new OFDReader(inputStream), this.ppm);
                imageMaker.isStamp = true;
                imageMaker.config.setDrawBoundary(this.config.drawBoundary);
                if (imageMaker.pageSize() > 0) {
                    this.logger.debug("\u6e32\u67d3ofd\u683c\u5f0f\u5370\u7ae0");
                    stampImage = imageMaker.makePage(0);
                }
            } else {
                stampImage = ImageIO.read(inputStream);
            }
            if (stampImage != null) {
                if (this.config.clearStampBackground) {
                    stampImage = ImageUtils.clearWhiteBackground(stampImage, this.config.stampBackgroundGray);
                }
                ST_Box stBox = stampAnnot.getBoundary();
                ST_Box clip = stampAnnot.getClip();
                Matrix m = MatrixUtils.base();
                graphics.setTransform(MatrixUtils.createAffineTransform(m));
                double fx = stBox.getWidth() / (double)stampImage.getWidth();
                double fy = stBox.getHeight() / (double)stampImage.getHeight();
                m = MatrixUtils.scale(m, fx, fy);
                m = MatrixUtils.move(m, stBox.getTopLeftX(), stBox.getTopLeftY());
                m = MatrixUtils.scale(m, this.ppm, this.ppm);
                if (clip != null) {
                    Matrix m1 = MatrixUtils.base();
                    m1 = MatrixUtils.scale(m1, fx, fy);
                    m1 = MatrixUtils.move(m1, stBox.getTopLeftX() + clip.getTopLeftX(), stBox.getTopLeftY() + clip.getTopLeftY());
                    m1 = MatrixUtils.scale(m1, this.ppm, this.ppm);
                    graphics.setClip((int)m1.getAsDouble(2L, 0L), (int)m1.getAsDouble(2L, 1L), (int)((double)stampImage.getWidth() * m1.getAsDouble(0L, 0L) * (clip.getWidth() / stBox.getWidth())), (int)((double)stampImage.getHeight() * m1.getAsDouble(1L, 1L) * (clip.getHeight() / stBox.getHeight())));
                }
                graphics.setComposite(this.getStampComposite());
                graphics.drawImage(stampImage, MatrixUtils.createAffineTransform(m), null);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5370\u7ae0\u7ed8\u5236\u5f02\u5e38", e);
        }
        finally {
            graphics.dispose();
        }
    }

    protected Composite getStampComposite() {
        return BlendComposite.getInstance(BlendMode.MULTIPLY, 1.0f);
    }

    protected void writePage(Graphics2D graphics, PageInfo pageInfo, Matrix matrix) {
        List<CT_Layer> layerList = pageInfo.getAllLayer();
        for (CT_Layer layer : layerList) {
            this.writeContent(graphics, layer, null, matrix);
        }
        String pageId = pageInfo.getId().toString();
        for (StampAnnotEntity stampAnnotEntity : this.reader.getStampAnnots()) {
            List<StampAnnot> stampAnnots = stampAnnotEntity.getStampAnnots();
            for (StampAnnot stampAnnot : stampAnnots) {
                if (!stampAnnot.getPageRef().toString().equals(pageId)) continue;
                this.writeStampAnnot(graphics, stampAnnotEntity, stampAnnot);
            }
        }
        for (AnnotionEntity annotionEntity : this.reader.getAnnotationEntities()) {
            if (!pageId.equals(annotionEntity.getPageId()) || null == annotionEntity.getAnnots()) continue;
            for (Annot annot : annotionEntity.getAnnots()) {
                Appearance appearance = annot.getAppearance();
                this.writeContent(graphics, appearance, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(Graphics2D graphics, CT_PageBlock pageBlock, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        graphics = (Graphics2D)graphics.create();
        try {
            if (drawParams == null) {
                drawParams = new ArrayList<CT_DrawParam>();
            }
            if (parentMatrix == null) {
                parentMatrix = MatrixUtils.base();
            }
            if (pageBlock instanceof CT_Layer) {
                ST_RefID drawParamRef = ((CT_Layer)pageBlock).getDrawParam();
                this.addDrawParams(drawParams, drawParamRef);
            }
            if (pageBlock.attribute("Boundary") != null) {
                String data = (String)pageBlock.attribute("Boundary").getData();
                ST_Box stBox = ST_Box.getInstance(data);
                parentMatrix = MatrixUtils.move(parentMatrix, stBox.getTopLeftX(), stBox.getTopLeftY());
            }
            for (PageBlockType object : pageBlock.getPageBlocks()) {
                try {
                    if (object instanceof CT_GraphicUnit) {
                        drawParams = this.addDrawParams(drawParams, (CT_GraphicUnit)((Object)object));
                    }
                    if (object instanceof TextObject) {
                        TextObject textObject = (TextObject)object;
                        this.writeText(graphics, textObject, drawParams, parentMatrix);
                        continue;
                    }
                    if (object instanceof ImageObject) {
                        ImageObject imageObject = (ImageObject)object;
                        this.writeImage(graphics, imageObject, drawParams, parentMatrix);
                        continue;
                    }
                    if (object instanceof PathObject) {
                        PathObject pathObject = (PathObject)object;
                        this.writePath(graphics, pathObject, drawParams, parentMatrix);
                        continue;
                    }
                    if (object instanceof CompositeObject) {
                        CompositeObject compositeObject = (CompositeObject)object;
                        this.writeComposite(graphics, compositeObject, drawParams, parentMatrix);
                        continue;
                    }
                    if (object instanceof CT_PageBlock) {
                        CT_PageBlock block = (CT_PageBlock)object;
                        this.writeContent(graphics, block, drawParams, parentMatrix);
                        continue;
                    }
                    if (!(object instanceof CT_Layer)) continue;
                    CT_Layer layer = (CT_Layer)object;
                    ST_RefID drawParamRef = layer.getDrawParam();
                    if (drawParamRef != null) {
                        CT_DrawParam ctDrawParam = this.resourceManage.getDrawParam(drawParamRef.getRefId().toString());
                        drawParams.add(ctDrawParam);
                    }
                    this.writeContent(graphics, layer, drawParams, parentMatrix);
                }
                catch (Exception e) {
                    this.logger.warn("PageBlock\u65e0\u6cd5\u6e32\u67d3:", e);
                }
            }
        }
        finally {
            graphics.dispose();
        }
    }

    private void writeComposite(Graphics2D graphics, CompositeObject compositeObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        ST_RefID refID = compositeObject.getResourceID();
        if (refID == null) {
            return;
        }
        CT_VectorG vectorG = this.resourceManage.getCompositeGraphicUnit(refID.getRefId().getId().toString());
        if (vectorG == null) {
            return;
        }
        ST_Box boundary = compositeObject.getBoundary();
        Matrix m = MatrixUtils.base();
        if (compositeObject.getCTM() != null) {
            m = m.mtimes(MatrixUtils.ctm(compositeObject.getCTM().toDouble()));
        }
        if (boundary != null) {
            m = MatrixUtils.move(m, boundary.getTopLeftX(), boundary.getTopLeftY());
        }
        m = m.mtimes(parentMatrix);
        this.writeContent(graphics, vectorG.getContent(), drawParams, m);
    }

    private List<CT_DrawParam> addDrawParams(List<CT_DrawParam> drawParams, ST_RefID refID) {
        CT_DrawParam ctDrawParam;
        drawParams = new ArrayList<CT_DrawParam>(drawParams);
        if (refID != null && (ctDrawParam = this.resourceManage.getDrawParam(refID.getRefId().toString())) != null) {
            drawParams.add(ctDrawParam);
        }
        return drawParams;
    }

    private List<CT_DrawParam> addDrawParams(List<CT_DrawParam> drawParams, CT_GraphicUnit graphicUnit) {
        return this.addDrawParams(drawParams, graphicUnit.getDrawParam());
    }

    private void writePath(Graphics2D graphics, PathObject pathObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        Color fillColor;
        ST_Box boundary = pathObject.getBoundary();
        Matrix baseMatrix = this.renderBoundaryAndSetClip(graphics, boundary, parentMatrix);
        Matrix matrix = MatrixUtils.base();
        if (pathObject.getCTM() != null) {
            matrix = matrix.mtimes(MatrixUtils.ctm(pathObject.getCTM().toDouble()));
        }
        if (boundary != null) {
            matrix = MatrixUtils.move(matrix, boundary.getTopLeftX(), boundary.getTopLeftY());
        }
        matrix = matrix.mtimes(baseMatrix);
        graphics.transform(MatrixUtils.createAffineTransform(matrix));
        Path2D path2D = this.buildPath(pathObject.getAbbreviatedData());
        if (pathObject.getStroke() == null || pathObject.getStroke().booleanValue()) {
            graphics.setStroke(new BasicStroke(this.getLineWidth(pathObject, drawParams).floatValue()));
            Color strokeColor = this.getStrokeColor(pathObject.getStrokeColor(), CT_Color.rgb(0, 0, 0), drawParams);
            if (strokeColor != null) {
                graphics.setColor(strokeColor);
                graphics.draw(path2D);
            }
        }
        if (pathObject.getFill() != null && pathObject.getFill().booleanValue() && (fillColor = this.getFillColor(pathObject.getFillColor(), null, drawParams)) != null) {
            graphics.setColor(fillColor);
            graphics.fill(path2D);
        }
    }

    private void writeImage(Graphics2D graphics, ImageObject imageObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        BufferedImage image;
        ST_Box boundary = imageObject.getBoundary();
        Matrix baseMatrix = this.renderBoundaryAndSetClip(graphics, boundary, parentMatrix);
        try {
            image = this.resourceManage.getImage(imageObject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (image == null) {
            return;
        }
        Matrix m = MatrixUtils.base();
        m = MatrixUtils.scale(m, Double.valueOf(1.0 / (double)image.getWidth()).floatValue(), Double.valueOf(1.0 / (double)image.getHeight()).floatValue());
        if (imageObject.getCTM() != null) {
            m = m.mtimes(MatrixUtils.ctm(imageObject.getCTM().toDouble()));
        }
        if (boundary != null) {
            m = MatrixUtils.move(m, boundary.getTopLeftX(), boundary.getTopLeftY());
        }
        m = m.mtimes(baseMatrix);
        graphics.setTransform(MatrixUtils.createAffineTransform(MatrixUtils.base()));
        float alpha = 1.0f;
        if (imageObject.attributeValue("Alpha") != null) {
            alpha = (float)imageObject.getAlpha().intValue() / 255.0f;
        }
        Composite oldComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(10, alpha));
        graphics.setTransform(MatrixUtils.createAffineTransform(MatrixUtils.base()));
        graphics.drawImage(image, MatrixUtils.createAffineTransform(m), null);
        graphics.setComposite(oldComposite);
    }

    private void writeText(Graphics2D graphics, TextObject textObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        this.logger.debug("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501TextObject\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513");
        Double fontSize = textObject.getSize();
        Color strokeColor = this.getStrokeColor(textObject.getStrokeColor(), null, drawParams);
        Color fillColor = this.getFillColor(textObject.getFillColor(), null, drawParams);
        if (fillColor == null) {
            fillColor = Color.black;
        }
        ST_Box boundary = textObject.getBoundary();
        Matrix baseMatrix = this.renderBoundaryAndSetClip(graphics, boundary, parentMatrix);
        BasicStroke basicStroke = new BasicStroke(this.getLineWidth(textObject, drawParams).floatValue() * 15.0f, 0, 0);
        graphics.setStroke(basicStroke);
        FontWrapper<TrueTypeFont> fontWrapper = this.getFont(textObject);
        TrueTypeFont typeFont = fontWrapper.getFont();
        List<Number> fontMatrix = null;
        if (typeFont == null) {
            this.logger.info("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53ID\uff1a" + textObject.getFont());
            typeFont = FontLoader.getInstance().loadDefaultFont();
        } else {
            try {
                fontMatrix = typeFont.getFontMatrix();
            }
            catch (Exception e) {
                this.logger.warn("\u89e3\u6790\u52a0\u8f7d\u5f02\u5e38", e);
            }
        }
        CGTransformMap tsfMap = new CGTransformMap(textObject);
        int globalOffset = 0;
        Double previousX = null;
        Double previousY = null;
        for (TextCode textCode : textObject.getTextCodes()) {
            String content = StringUtils.removeNewline(textCode.getContent());
            int len = content.length();
            int offset = 0;
            ArrayList<GeneralPath> tbDrawChars = new ArrayList<GeneralPath>(5);
            while (offset < len) {
                int[] glyphIndexArr;
                CT_CGTransform tsfInfo = tsfMap.get(globalOffset);
                if (tsfInfo == null) {
                    char c = content.charAt(offset);
                    try {
                        GlyphData glyphData = typeFont.getUnicodeGlyph(c);
                        tbDrawChars.add(glyphData.getPath());
                    }
                    catch (IOException e) {
                        tbDrawChars.add(null);
                        this.logger.debug(String.format("\u627e\u4e0d\u5230\u5b57\u5f62 unicode: %c", Character.valueOf(c)));
                    }
                    ++globalOffset;
                    ++offset;
                    continue;
                }
                int codeCount = tsfInfo.getCodeCount();
                int glyphCount = tsfInfo.getGlyphCount();
                for (int gid : glyphIndexArr = tsfInfo.getGlyphs().expectIntArr(glyphCount)) {
                    try {
                        GeneralPath drawPath = typeFont.getPath(gid);
                        tbDrawChars.add(drawPath);
                    }
                    catch (IOException e) {
                        tbDrawChars.add(null);
                        this.logger.debug(String.format("\u627e\u4e0d\u5230\u5b57\u5f62 gid: %s", gid));
                    }
                }
                globalOffset += codeCount;
                offset += codeCount;
            }
            List<Double> deltaX = AWTMaker.parseDelta(textCode.getDeltaX());
            List<Double> deltaY = AWTMaker.parseDelta(textCode.getDeltaY());
            Double x = textCode.getX();
            if (x == null && previousX != null) {
                x = previousX;
            } else if (x == null) {
                x = 0.0;
            }
            Double y = textCode.getY();
            if (y == null && previousY != null) {
                y = previousY;
            } else if (y == null) {
                y = 0.0;
            }
            for (int drawOffset = 0; drawOffset < tbDrawChars.size(); ++drawOffset) {
                GeneralPath shape;
                int deltaOffset = drawOffset - 1;
                if (deltaOffset >= 0) {
                    if (deltaX.size() > 0) {
                        x = deltaOffset < deltaX.size() ? Double.valueOf(x + deltaX.get(deltaOffset)) : Double.valueOf(x + deltaX.get(deltaX.size() - 1));
                    }
                    if (deltaY.size() > 0) {
                        y = deltaOffset < deltaY.size() ? Double.valueOf(y + deltaY.get(deltaOffset)) : Double.valueOf(y + deltaY.get(deltaY.size() - 1));
                    }
                }
                if ((shape = (GeneralPath)tbDrawChars.get(drawOffset)) == null) continue;
                Matrix matrix = this.chatMatrix(textObject, x, y, fontSize, fontMatrix, baseMatrix);
                this.renderChar(graphics, shape, matrix, strokeColor, fillColor);
            }
            if (textCode.getX() != null) {
                previousX = textCode.getX();
            }
            if (textCode.getY() == null) continue;
            previousY = textCode.getY();
        }
        this.logger.debug("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b");
    }

    private Matrix chatMatrix(TextObject ctText, Double deltaX, Double deltaY, Double fontSize, List<Number> fontMatrix, Matrix baseMatrix) {
        Matrix m = MatrixUtils.base();
        m = MatrixUtils.imageMatrix(m, 0.0, 1.0, 0.0);
        if (ctText.getHScale() != null) {
            m = MatrixUtils.scale(m, ctText.getHScale(), 1.0);
        }
        m = m.mtimes(MatrixUtils.create(fontMatrix.get(0).doubleValue(), fontMatrix.get(1).doubleValue(), fontMatrix.get(2).doubleValue(), fontMatrix.get(3).doubleValue(), fontMatrix.get(4).doubleValue(), fontMatrix.get(5).doubleValue()));
        m = MatrixUtils.scale(m, fontSize, fontSize);
        m = MatrixUtils.move(m, deltaX, deltaY);
        if (ctText.getCTM() != null) {
            m = m.mtimes(MatrixUtils.ctm(ctText.getCTM().toDouble()));
        }
        if (ctText.getBoundary() != null) {
            m = MatrixUtils.move(m, ctText.getBoundary().getTopLeftX(), ctText.getBoundary().getTopLeftY());
        }
        m = m.mtimes(baseMatrix);
        return m;
    }

    private void renderChar(Graphics2D graphics, Shape shape, Matrix m, Color stroke, Color fill) {
        if (shape == null) {
            return;
        }
        graphics.setClip(null);
        graphics.setTransform(MatrixUtils.createAffineTransform(m));
        graphics.setColor(Color.BLACK);
        graphics.setBackground(Color.white);
        if (stroke != null) {
            graphics.setColor(stroke);
            graphics.draw(shape);
        }
        if (fill != null) {
            graphics.setColor(fill);
            graphics.fill(shape);
        }
    }

    private FontWrapper<TrueTypeFont> getFont(TextObject textObject) {
        ST_RefID stRefID = textObject.getFont();
        if (stRefID == null) {
            return null;
        }
        CT_Font ctFont = this.resourceManage.getFont(stRefID.toString());
        if (ctFont == null) {
            return null;
        }
        String key = String.format("%s_%s_%s", ctFont.getFamilyName(), ctFont.getFontName(), ctFont.getFontFile());
        if (this.fontCache.containsKey(key)) {
            return this.fontCache.get(key);
        }
        FontWrapper<TrueTypeFont> trueTypeFont = FontLoader.getInstance().loadFontSimilar(this.reader.getResourceLocator(), ctFont);
        this.fontCache.put(key, trueTypeFont);
        return trueTypeFont;
    }

    private Matrix renderBoundaryAndSetClip(Graphics2D graphics, ST_Box boundary, Matrix parentMatrix) {
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(0.1f * (float)this.ppm));
        Matrix m = MatrixUtils.base().mtimes(parentMatrix);
        if (boundary != null) {
            graphics.setTransform(new AffineTransform());
            Polygon shape = new Polygon();
            Tuple2<Double, Double> p00 = MatrixUtils.pointTransform(m, boundary.getTopLeftX(), boundary.getTopLeftY() - 1.0);
            Tuple2<Double, Double> p01 = MatrixUtils.pointTransform(m, boundary.getTopLeftX() + boundary.getWidth() + 2.0, boundary.getTopLeftY() - 1.0);
            Tuple2<Double, Double> p10 = MatrixUtils.pointTransform(m, boundary.getTopLeftX(), boundary.getTopLeftY() + boundary.getHeight() + 2.0);
            Tuple2<Double, Double> p11 = MatrixUtils.pointTransform(m, boundary.getTopLeftX() + boundary.getWidth() + 2.0, boundary.getTopLeftY() + boundary.getHeight() + 2.0);
            shape.addPoint(Double.valueOf(p00.getFirst() * this.ppm).intValue(), Double.valueOf(p00.getSecond() * this.ppm).intValue());
            shape.addPoint(Double.valueOf(p01.getFirst() * this.ppm).intValue(), Double.valueOf(p01.getSecond() * this.ppm).intValue());
            shape.addPoint(Double.valueOf(p11.getFirst() * this.ppm).intValue(), Double.valueOf(p11.getSecond() * this.ppm).intValue());
            shape.addPoint(Double.valueOf(p10.getFirst() * this.ppm).intValue(), Double.valueOf(p10.getSecond() * this.ppm).intValue());
            graphics.setClip(null);
            if (this.config.drawBoundary) {
                graphics.draw(shape);
            }
            if (this.config.clip) {
                graphics.setClip(shape);
            }
        }
        m = MatrixUtils.scale(m, this.ppm, this.ppm);
        return m;
    }

    private Path2D buildPath(String abbreviatedData) {
        LinkedList<OptVal> optValArr = AbbreviatedData.parse(abbreviatedData);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, 0.0);
        for (OptVal optVal : optValArr) {
            double[] arr = optVal.expectValues();
            switch (optVal.opt) {
                case "S": 
                case "M": {
                    ((Path2D)path).moveTo(arr[0], arr[1]);
                    break;
                }
                case "L": {
                    ((Path2D)path).lineTo(arr[0], arr[1]);
                    break;
                }
                case "Q": {
                    ((Path2D)path).quadTo(arr[0], arr[1], arr[2], arr[3]);
                    break;
                }
                case "B": {
                    ((Path2D)path).curveTo(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
                    break;
                }
                case "A": {
                    break;
                }
                case "C": {
                    path.closePath();
                }
            }
        }
        return path;
    }

    private Double getLineWidth(CT_GraphicUnit graphicUnit, List<CT_DrawParam> drawParams) {
        Double lineWidth = graphicUnit.getLineWidth();
        if (lineWidth != null) {
            return lineWidth;
        }
        this.logger.debug("LineWidth \u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c0.4\u6beb\u7c73");
        return 0.4;
    }

    private Color getStrokeColor(CT_Color color, CT_Color defaultColor, List<CT_DrawParam> drawParams) {
        CT_Color c = color;
        if (c == null) {
            CT_DrawParam drawParam;
            Iterator<CT_DrawParam> iterator = drawParams.iterator();
            while (iterator.hasNext() && (c = (drawParam = iterator.next()).getStrokeColor()) == null) {
            }
        }
        if (c == null) {
            c = defaultColor;
        }
        return this.getColor(c);
    }

    private Color getFillColor(CT_Color color, CT_Color defaultColor, List<CT_DrawParam> drawParams) {
        CT_Color c = color;
        if (c == null) {
            CT_DrawParam drawParam;
            Iterator<CT_DrawParam> iterator = drawParams.iterator();
            while (iterator.hasNext() && (c = (drawParam = iterator.next()).getFillColor()) == null) {
            }
        }
        if (c == null) {
            c = defaultColor;
        }
        return this.getColor(c);
    }

    public Color getColor(CT_Color ctColor) {
        if (ctColor == null) {
            return null;
        }
        ST_Array array = ctColor.getValue();
        OFDColorSpaceType type = OFDColorSpaceType.RGB;
        ST_RefID refID = ctColor.getColorSpace();
        CT_ColorSpace ctColorSpace = null;
        if (refID != null) {
            ctColorSpace = this.resourceManage.getColorSpace(refID.toString());
        }
        if (ctColorSpace != null) {
            if (ctColorSpace.getType() != null) {
                type = ctColorSpace.getType();
            }
            if (array == null && ctColor.getIndex() != null) {
                array = ctColorSpace.getPalette().getColorByIndex(ctColor.getIndex());
            }
        }
        if (array == null) {
            return null;
        }
        int[] color = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            String s = array.getArray().get(i);
            color[i] = s.startsWith("#") ? Integer.parseInt(s.replaceAll("#", ""), 16) : ("0.0".equals(s) ? 0 : Integer.parseInt(s));
        }
        switch (type) {
            case GRAY: {
                return new Color(color[0], color[0], color[0]);
            }
            case CMYK: {
                int r = 255 * (100 - color[0]) * (100 - color[3]) / 10000;
                int g = 255 * (100 - color[1]) * (100 - color[3]) / 10000;
                int b = 255 * (100 - color[2]) * (100 - color[3]) / 10000;
                return new Color(r, g, b);
            }
        }
        return new Color(color[0], color[1], color[2]);
    }

    public void setPPM(double ppm) {
        if (ppm <= 0.0) {
            return;
        }
        this.ppm = ppm;
    }

    public static List<Double> parseDelta(ST_Array array) {
        if (array == null) {
            return new ArrayList<Double>(0);
        }
        ArrayList<Double> arr = new ArrayList<Double>();
        int i = 0;
        while (i < array.size()) {
            String current = array.getArray().get(i);
            if ("g".equals(current)) {
                int num = Integer.parseInt(array.getArray().get(i + 1));
                Double delta = Double.valueOf(array.getArray().get(i + 2));
                for (int j = 1; j <= num; ++j) {
                    arr.add(delta);
                }
                i += 3;
                continue;
            }
            Double delta = Double.valueOf(current);
            arr.add(delta);
            ++i;
        }
        return arr;
    }

    public static class Config {
        private float stampOpacity = 0.75f;
        private boolean clearStampBackground = true;
        private int stampBackgroundGray = 255;
        private boolean drawBoundary;
        private boolean clip = true;

        public float getStampOpacity() {
            return this.stampOpacity;
        }

        public void setStampOpacity(float stampOpacity) {
            if (stampOpacity >= 0.0f && stampOpacity <= 1.0f) {
                this.stampOpacity = stampOpacity;
            }
        }

        public boolean isDrawBoundary() {
            return this.drawBoundary;
        }

        public void setDrawBoundary(boolean drawBoundary) {
            this.drawBoundary = drawBoundary;
        }

        public boolean isClearStampBackground() {
            return this.clearStampBackground;
        }

        public void setClearStampBackground(boolean clearStampBackground) {
            this.clearStampBackground = clearStampBackground;
        }

        public int getStampBackgroundGray() {
            return this.stampBackgroundGray;
        }

        public void setStampBackgroundGray(int stampBackgroundGray) {
            if (stampBackgroundGray < 0 || stampBackgroundGray > 255) {
                stampBackgroundGray = 255;
            }
            this.stampBackgroundGray = stampBackgroundGray;
        }

        public boolean isClip() {
            return this.clip;
        }

        public void setClip(boolean clip) {
            this.clip = clip;
        }
    }
}

