/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.PositionedLayoutContext;
import com.itextpdf.layout.layout.RootLayoutArea;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.property.ClearPropertyValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.RootRendererAreaStateHandler;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootRenderer
extends AbstractRenderer {
    protected boolean immediateFlush = true;
    protected RootLayoutArea currentArea;
    protected int currentPageNumber;
    protected List<IRenderer> waitingDrawingElements = new ArrayList<IRenderer>();
    List<Rectangle> floatRendererAreas;
    private IRenderer keepWithNextHangingRenderer;
    private LayoutResult keepWithNextHangingRendererLayoutResult;
    private MarginsCollapseHandler marginsCollapseHandler;
    private LayoutArea initialCurrentArea;
    private List<IRenderer> waitingNextPageRenderers = new ArrayList<IRenderer>();
    private boolean floatOverflowedCompletely = false;

    /*
     * Unable to fully structure code
     */
    @Override
    public void addChild(IRenderer renderer) {
        taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
        if (taggingHelper != null) {
            LayoutTaggingHelper.addTreeHints(taggingHelper, renderer);
        }
        numberOfChildRenderers = this.childRenderers.size();
        numberOfPositionedChildRenderers = this.positionedRenderers.size();
        super.addChild(renderer);
        addedRenderers = new ArrayList<E>(1);
        addedPositionedRenderers = new ArrayList<E>(1);
        while (this.childRenderers.size() > numberOfChildRenderers) {
            addedRenderers.add(this.childRenderers.get(numberOfChildRenderers));
            this.childRenderers.remove(numberOfChildRenderers);
        }
        while (this.positionedRenderers.size() > numberOfPositionedChildRenderers) {
            addedPositionedRenderers.add(this.positionedRenderers.get(numberOfPositionedChildRenderers));
            this.positionedRenderers.remove(numberOfPositionedChildRenderers);
        }
        marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (this.currentArea == null) {
            this.updateCurrentAndInitialArea(null);
            if (marginsCollapsingEnabled) {
                this.marginsCollapseHandler = new MarginsCollapseHandler(this, null);
            }
        }
        for (i = 0; this.currentArea != null && i < addedRenderers.size(); ++i) {
            rootRendererStateHandler = new RootRendererAreaStateHandler();
            renderer = (IRenderer)addedRenderers.get(i);
            rendererIsFloat = FloatingHelper.isRendererFloating(renderer);
            clearanceOverflowsToNextPage = FloatingHelper.isClearanceApplied(this.waitingNextPageRenderers, (ClearPropertyValue)renderer.getProperty(100));
            if (rendererIsFloat && (this.floatOverflowedCompletely || clearanceOverflowsToNextPage)) {
                this.waitingNextPageRenderers.add(renderer);
                this.floatOverflowedCompletely = true;
                continue;
            }
            this.processWaitingKeepWithNextElement(renderer);
            resultRenderers = new ArrayList<IRenderer>();
            result = null;
            childMarginsInfo = null;
            if (marginsCollapsingEnabled && this.currentArea != null && renderer != null) {
                childMarginsInfo = this.marginsCollapseHandler.startChildMarginsHandling(renderer, this.currentArea.getBBox());
            }
            while (clearanceOverflowsToNextPage || this.currentArea != null && renderer != null && (result = renderer.setParent(this).layout(new LayoutContext(this.currentArea.clone(), childMarginsInfo, this.floatRendererAreas))).getStatus() != 1) {
                block37: {
                    block38: {
                        block36: {
                            currentAreaNeedsToBeUpdated = false;
                            if (clearanceOverflowsToNextPage) {
                                result = new LayoutResult(3, null, null, renderer);
                                currentAreaNeedsToBeUpdated = true;
                            }
                            if (result.getStatus() != 2) break block36;
                            if (rendererIsFloat) {
                                this.waitingNextPageRenderers.add(result.getOverflowRenderer());
                                break;
                            }
                            this.processRenderer(result.getSplitRenderer(), resultRenderers);
                            if (!rootRendererStateHandler.attemptGoForwardToStoredNextState(this)) {
                                currentAreaNeedsToBeUpdated = true;
                            }
                            break block37;
                        }
                        if (result.getStatus() != 3 || clearanceOverflowsToNextPage) break block37;
                        if (!(result.getOverflowRenderer() instanceof ImageRenderer)) break block38;
                        imgHeight = ((ImageRenderer)result.getOverflowRenderer()).getOccupiedArea().getBBox().getHeight();
                        if (!this.floatRendererAreas.isEmpty() || this.currentArea.getBBox().getHeight() < imgHeight && !this.currentArea.isEmptyArea()) {
                            if (rendererIsFloat) {
                                this.waitingNextPageRenderers.add(result.getOverflowRenderer());
                                this.floatOverflowedCompletely = true;
                                break;
                            }
                            currentAreaNeedsToBeUpdated = true;
                        } else {
                            ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                            result.getOverflowRenderer().setProperty(26, true);
                            logger = LoggerFactory.getLogger(RootRenderer.class);
                            logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", new Object[]{""}));
                        }
                        break block37;
                    }
                    if (!this.currentArea.isEmptyArea() || result.getAreaBreak() != null) ** GOTO lbl104
                    if (Boolean.TRUE.equals(result.getOverflowRenderer().getModelElement().getProperty(32))) {
                        result.getOverflowRenderer().getModelElement().setProperty(32, false);
                        logger = LoggerFactory.getLogger(RootRenderer.class);
                        logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", new Object[]{"KeepTogether property will be ignored."}));
                        if (!rendererIsFloat) {
                            rootRendererStateHandler.attemptGoBackToStoredPreviousStateAndStoreNextState(this);
                        }
                    } else if (null != result.getCauseOfNothing() && Boolean.TRUE.equals(result.getCauseOfNothing().getProperty(32))) {
                        theDeepestKeptTogether = result.getCauseOfNothing();
                        while ((null == theDeepestKeptTogether.getModelElement() || null == theDeepestKeptTogether.getModelElement().getOwnProperty(32)) && (parent = ((AbstractRenderer)theDeepestKeptTogether).parent) != null) {
                            theDeepestKeptTogether = parent;
                        }
                        theDeepestKeptTogether.getModelElement().setProperty(32, false);
                        logger = LoggerFactory.getLogger(RootRenderer.class);
                        logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", new Object[]{"KeepTogether property of inner element will be ignored."}));
                        if (!rendererIsFloat) {
                            rootRendererStateHandler.attemptGoBackToStoredPreviousStateAndStoreNextState(this);
                        }
                    } else if (!Boolean.TRUE.equals(renderer.getProperty(26))) {
                        result.getOverflowRenderer().setProperty(26, true);
                        logger = LoggerFactory.getLogger(RootRenderer.class);
                        logger.warn(MessageFormatUtil.format("Element does not fit current area. {0}", new Object[]{""}));
                    } else {
                        if (!RootRenderer.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
lbl104:
                        // 1 sources

                        rootRendererStateHandler.storePreviousState(this);
                        if (!rootRendererStateHandler.attemptGoForwardToStoredNextState(this)) {
                            if (rendererIsFloat) {
                                this.waitingNextPageRenderers.add(result.getOverflowRenderer());
                                this.floatOverflowedCompletely = true;
                                break;
                            }
                            currentAreaNeedsToBeUpdated = true;
                        }
                    }
                }
                renderer = result.getOverflowRenderer();
                if (marginsCollapsingEnabled) {
                    this.marginsCollapseHandler.endChildMarginsHandling(this.currentArea.getBBox());
                }
                if (currentAreaNeedsToBeUpdated) {
                    this.updateCurrentAndInitialArea(result);
                }
                if (marginsCollapsingEnabled) {
                    this.marginsCollapseHandler = new MarginsCollapseHandler(this, null);
                    childMarginsInfo = this.marginsCollapseHandler.startChildMarginsHandling(renderer, this.currentArea.getBBox());
                }
                clearanceOverflowsToNextPage = clearanceOverflowsToNextPage != false && FloatingHelper.isClearanceApplied(this.waitingNextPageRenderers, (ClearPropertyValue)renderer.getProperty(100)) != false;
            }
            if (marginsCollapsingEnabled) {
                this.marginsCollapseHandler.endChildMarginsHandling(this.currentArea.getBBox());
            }
            if (null != result && null != result.getSplitRenderer()) {
                renderer = result.getSplitRenderer();
            }
            if (renderer == null || result == null) continue;
            if (Boolean.TRUE.equals(renderer.getProperty(81))) {
                if (Boolean.TRUE.equals(renderer.getProperty(26))) {
                    logger = LoggerFactory.getLogger(RootRenderer.class);
                    logger.warn("Element was placed in a forced way. Keep with next property will be ignored");
                    this.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
                    continue;
                }
                this.keepWithNextHangingRenderer = renderer;
                this.keepWithNextHangingRendererLayoutResult = result;
                continue;
            }
            if (result.getStatus() == 3) continue;
            this.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
        }
        for (i = 0; i < addedPositionedRenderers.size(); ++i) {
            this.positionedRenderers.add(addedPositionedRenderers.get(i));
            renderer = (IRenderer)this.positionedRenderers.get(this.positionedRenderers.size() - 1);
            positionedPageNumber = (Integer)renderer.getProperty(51);
            if (positionedPageNumber == null) {
                positionedPageNumber = this.currentPageNumber;
            }
            layoutArea = Integer.valueOf(3).equals(renderer.getProperty(52)) != false && AbstractRenderer.noAbsolutePositionInfo(renderer) != false ? new LayoutArea(positionedPageNumber, this.currentArea.getBBox().clone()) : new LayoutArea(positionedPageNumber, this.initialCurrentArea.getBBox().clone());
            fullBbox = layoutArea.getBBox().clone();
            this.preparePositionedRendererAndAreaForLayout(renderer, fullBbox, layoutArea.getBBox());
            renderer.layout(new PositionedLayoutContext(new LayoutArea(layoutArea.getPageNumber(), fullBbox), layoutArea));
            if (!this.immediateFlush) continue;
            this.flushSingleRenderer(renderer);
            this.positionedRenderers.remove(this.positionedRenderers.size() - 1);
        }
    }

    public void flush() {
        for (IRenderer resultRenderer : this.childRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        for (IRenderer resultRenderer : this.positionedRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        this.childRenderers.clear();
        this.positionedRenderers.clear();
    }

    public void close() {
        this.addAllWaitingNextPageRenderers();
        if (this.keepWithNextHangingRenderer != null) {
            this.keepWithNextHangingRenderer.setProperty(81, false);
            IRenderer rendererToBeAdded = this.keepWithNextHangingRenderer;
            this.keepWithNextHangingRenderer = null;
            this.addChild(rendererToBeAdded);
        }
        if (!this.immediateFlush) {
            this.flush();
        }
        this.flushWaitingDrawingElements(true);
        LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
        if (taggingHelper != null) {
            taggingHelper.releaseAllHints();
        }
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        throw new IllegalStateException("Layout is not supported for root renderers.");
    }

    public LayoutArea getCurrentArea() {
        if (this.currentArea == null) {
            this.updateCurrentAndInitialArea(null);
        }
        return this.currentArea;
    }

    protected abstract void flushSingleRenderer(IRenderer var1);

    protected abstract LayoutArea updateCurrentArea(LayoutResult var1);

    protected void shrinkCurrentAreaAndProcessRenderer(IRenderer renderer, List<IRenderer> resultRenderers, LayoutResult result) {
        if (this.currentArea != null) {
            float resultRendererHeight = result.getOccupiedArea().getBBox().getHeight();
            this.currentArea.getBBox().setHeight(this.currentArea.getBBox().getHeight() - resultRendererHeight);
            if (this.currentArea.isEmptyArea() && (resultRendererHeight > 0.0f || FloatingHelper.isRendererFloating(renderer))) {
                this.currentArea.setEmptyArea(false);
            }
            this.processRenderer(renderer, resultRenderers);
        }
        if (!this.immediateFlush) {
            this.childRenderers.addAll(resultRenderers);
        }
    }

    protected void flushWaitingDrawingElements() {
        this.flushWaitingDrawingElements(true);
    }

    void flushWaitingDrawingElements(boolean force) {
        HashSet<IRenderer> flushedElements = new HashSet<IRenderer>();
        for (int i = 0; i < this.waitingDrawingElements.size(); ++i) {
            IRenderer waitingDrawingElement = this.waitingDrawingElements.get(i);
            if (force || null != waitingDrawingElement.getOccupiedArea() && waitingDrawingElement.getOccupiedArea().getPageNumber() < this.currentArea.getPageNumber()) {
                this.flushSingleRenderer(waitingDrawingElement);
                flushedElements.add(waitingDrawingElement);
                continue;
            }
            if (null != waitingDrawingElement.getOccupiedArea()) continue;
            flushedElements.add(waitingDrawingElement);
        }
        this.waitingDrawingElements.removeAll(flushedElements);
    }

    private void processRenderer(IRenderer renderer, List<IRenderer> resultRenderers) {
        this.alignChildHorizontally(renderer, this.currentArea.getBBox());
        if (this.immediateFlush) {
            this.flushSingleRenderer(renderer);
        } else {
            resultRenderers.add(renderer);
        }
    }

    private void processWaitingKeepWithNextElement(IRenderer renderer) {
        if (this.keepWithNextHangingRenderer != null) {
            LayoutArea rest = this.currentArea.clone();
            rest.getBBox().setHeight(rest.getBBox().getHeight() - this.keepWithNextHangingRendererLayoutResult.getOccupiedArea().getBBox().getHeight());
            boolean ableToProcessKeepWithNext = false;
            if (renderer.setParent(this).layout(new LayoutContext(rest)).getStatus() != 3) {
                this.shrinkCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
                ableToProcessKeepWithNext = true;
            } else {
                int i;
                float originalElementHeight = this.keepWithNextHangingRendererLayoutResult.getOccupiedArea().getBBox().getHeight();
                ArrayList<Float> trySplitHeightPoints = new ArrayList<Float>();
                float delta = 35.0f;
                for (i = 1; i <= 5 && originalElementHeight - delta * (float)i > originalElementHeight / 2.0f; ++i) {
                    trySplitHeightPoints.add(Float.valueOf(originalElementHeight - delta * (float)i));
                }
                for (i = 0; i < trySplitHeightPoints.size() && !ableToProcessKeepWithNext; ++i) {
                    float curElementSplitHeight = ((Float)trySplitHeightPoints.get(i)).floatValue();
                    RootLayoutArea firstElementSplitLayoutArea = (RootLayoutArea)this.currentArea.clone();
                    firstElementSplitLayoutArea.getBBox().setHeight(curElementSplitHeight).moveUp(this.currentArea.getBBox().getHeight() - curElementSplitHeight);
                    LayoutResult firstElementSplitLayoutResult = this.keepWithNextHangingRenderer.setParent(this).layout(new LayoutContext(firstElementSplitLayoutArea.clone()));
                    if (firstElementSplitLayoutResult.getStatus() != 2) continue;
                    RootLayoutArea storedArea = this.currentArea;
                    this.updateCurrentAndInitialArea(firstElementSplitLayoutResult);
                    LayoutResult firstElementOverflowLayoutResult = firstElementSplitLayoutResult.getOverflowRenderer().layout(new LayoutContext(this.currentArea.clone()));
                    if (firstElementOverflowLayoutResult.getStatus() == 1) {
                        LayoutArea secondElementLayoutArea = this.currentArea.clone();
                        secondElementLayoutArea.getBBox().setHeight(secondElementLayoutArea.getBBox().getHeight() - firstElementOverflowLayoutResult.getOccupiedArea().getBBox().getHeight());
                        LayoutResult secondElementLayoutResult = renderer.setParent(this).layout(new LayoutContext(secondElementLayoutArea));
                        if (secondElementLayoutResult.getStatus() != 3) {
                            ableToProcessKeepWithNext = true;
                            this.currentArea = firstElementSplitLayoutArea;
                            this.currentPageNumber = firstElementSplitLayoutArea.getPageNumber();
                            this.shrinkCurrentAreaAndProcessRenderer(firstElementSplitLayoutResult.getSplitRenderer(), new ArrayList<IRenderer>(), firstElementSplitLayoutResult);
                            this.updateCurrentAndInitialArea(firstElementSplitLayoutResult);
                            this.shrinkCurrentAreaAndProcessRenderer(firstElementSplitLayoutResult.getOverflowRenderer(), new ArrayList<IRenderer>(), firstElementOverflowLayoutResult);
                        }
                    }
                    if (ableToProcessKeepWithNext) continue;
                    this.currentArea = storedArea;
                    this.currentPageNumber = storedArea.getPageNumber();
                }
            }
            if (!ableToProcessKeepWithNext && !this.currentArea.isEmptyArea()) {
                RootLayoutArea storedArea = this.currentArea;
                this.updateCurrentAndInitialArea(null);
                LayoutResult firstElementLayoutResult = this.keepWithNextHangingRenderer.setParent(this).layout(new LayoutContext(this.currentArea.clone()));
                if (firstElementLayoutResult.getStatus() == 1) {
                    LayoutArea secondElementLayoutArea = this.currentArea.clone();
                    secondElementLayoutArea.getBBox().setHeight(secondElementLayoutArea.getBBox().getHeight() - firstElementLayoutResult.getOccupiedArea().getBBox().getHeight());
                    LayoutResult secondElementLayoutResult = renderer.setParent(this).layout(new LayoutContext(secondElementLayoutArea));
                    if (secondElementLayoutResult.getStatus() != 3) {
                        ableToProcessKeepWithNext = true;
                        this.shrinkCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
                    }
                }
                if (!ableToProcessKeepWithNext) {
                    this.currentArea = storedArea;
                    this.currentPageNumber = storedArea.getPageNumber();
                }
            }
            if (!ableToProcessKeepWithNext) {
                Logger logger = LoggerFactory.getLogger(RootRenderer.class);
                logger.warn("The renderer was not able to process keep with next property properly");
                this.shrinkCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
            }
            this.keepWithNextHangingRenderer = null;
            this.keepWithNextHangingRendererLayoutResult = null;
        }
    }

    private void updateCurrentAndInitialArea(LayoutResult overflowResult) {
        this.floatRendererAreas = new ArrayList<Rectangle>();
        this.updateCurrentArea(overflowResult);
        this.initialCurrentArea = this.currentArea == null ? null : this.currentArea.clone();
        this.addWaitingNextPageRenderers();
    }

    private void addAllWaitingNextPageRenderers() {
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        while (!this.waitingNextPageRenderers.isEmpty()) {
            if (marginsCollapsingEnabled) {
                this.marginsCollapseHandler = new MarginsCollapseHandler(this, null);
            }
            this.updateCurrentAndInitialArea(null);
        }
    }

    private void addWaitingNextPageRenderers() {
        this.floatOverflowedCompletely = false;
        ArrayList<IRenderer> waitingFloatRenderers = new ArrayList<IRenderer>(this.waitingNextPageRenderers);
        this.waitingNextPageRenderers.clear();
        for (IRenderer renderer : waitingFloatRenderers) {
            this.addChild(renderer);
        }
    }
}

