/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.io.font.constants.StandardFonts;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.DocFontEncoding;
import com.itextpdf.kernel.font.DocTrueTypeFont;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.font.PdfSimpleFont;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTrueTypeFont
extends PdfSimpleFont<TrueTypeFont> {
    private static final long serialVersionUID = -8152778382960290571L;

    PdfTrueTypeFont(TrueTypeFont ttf, String encoding, boolean embedded) {
        this.setFontProgram(ttf);
        this.embedded = embedded;
        FontNames fontNames = ttf.getFontNames();
        if (embedded && !fontNames.allowEmbedding()) {
            throw new PdfException("{0} cannot be embedded due to licensing restrictions.").setMessageParams(fontNames.getFontName());
        }
        if ((encoding == null || encoding.length() == 0) && ttf.isFontSpecific()) {
            encoding = "FontSpecific";
        }
        this.fontEncoding = encoding != null && "FontSpecific".toLowerCase().equals(encoding.toLowerCase()) ? FontEncoding.createFontSpecificEncoding() : FontEncoding.createFontEncoding(encoding);
    }

    PdfTrueTypeFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.newFont = false;
        this.subset = false;
        this.fontEncoding = DocFontEncoding.createDocFontEncoding(fontDictionary.get(PdfName.Encoding), this.toUnicode);
        PdfName baseFontName = fontDictionary.getAsName(PdfName.BaseFont);
        if (baseFontName != null && StandardFonts.isStandardFont(baseFontName.getValue()) && !fontDictionary.containsKey(PdfName.FontDescriptor) && !fontDictionary.containsKey(PdfName.Widths)) {
            try {
                this.fontProgram = FontProgramFactory.createFont(baseFontName.getValue(), true);
            }
            catch (IOException e) {
                throw new PdfException("I/O exception while creating Font", e);
            }
        } else {
            this.fontProgram = DocTrueTypeFont.createFontProgram(fontDictionary, this.fontEncoding, this.toUnicode);
        }
        this.embedded = this.fontProgram instanceof IDocFontProgram && ((IDocFontProgram)((Object)this.fontProgram)).getFontFile() != null;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        if (this.fontEncoding.canEncode(unicode)) {
            Glyph notdef;
            Glyph glyph = this.getFontProgram().getGlyph(this.fontEncoding.getUnicodeDifference(unicode));
            if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null && (notdef = this.getFontProgram().getGlyphByCode(0)) != null) {
                glyph = new Glyph(this.getFontProgram().getGlyphByCode(0), unicode);
                this.notdefGlyphs.put(unicode, glyph);
            }
            return glyph;
        }
        return null;
    }

    @Override
    public boolean containsGlyph(int unicode) {
        if (this.fontEncoding.isFontSpecific()) {
            return this.fontProgram.getGlyphByCode(unicode) != null;
        }
        return this.fontEncoding.canEncode(unicode) && this.getFontProgram().getGlyph(this.fontEncoding.getUnicodeDifference(unicode)) != null;
    }

    @Override
    public void flush() {
        if (this.isFlushed()) {
            return;
        }
        this.ensureUnderlyingObjectHasIndirectReference();
        if (this.newFont) {
            String fontName;
            PdfName subtype;
            if (((TrueTypeFont)this.getFontProgram()).isCff()) {
                subtype = PdfName.Type1;
                fontName = this.fontProgram.getFontNames().getFontName();
            } else {
                subtype = PdfName.TrueType;
                fontName = PdfTrueTypeFont.updateSubsetPrefix(this.fontProgram.getFontNames().getFontName(), this.subset, this.embedded);
            }
            this.flushFontData(fontName, subtype);
        }
        super.flush();
    }

    @Deprecated
    protected void addRangeUni(Set<Integer> longTag) {
        ((TrueTypeFont)this.getFontProgram()).updateUsedGlyphs((SortedSet)longTag, this.subset, this.subsetRanges);
    }

    @Override
    protected void addFontStream(PdfDictionary fontDescriptor) {
        if (this.embedded) {
            PdfStream fontStream;
            PdfName fontFileName;
            if (this.fontProgram instanceof IDocFontProgram) {
                fontFileName = ((IDocFontProgram)((Object)this.fontProgram)).getFontFileName();
                fontStream = ((IDocFontProgram)((Object)this.fontProgram)).getFontFile();
            } else if (((TrueTypeFont)this.getFontProgram()).isCff()) {
                fontFileName = PdfName.FontFile3;
                try {
                    byte[] fontStreamBytes = ((TrueTypeFont)this.getFontProgram()).getFontStreamBytes();
                    fontStream = this.getPdfFontStream(fontStreamBytes, new int[]{fontStreamBytes.length});
                    fontStream.put(PdfName.Subtype, new PdfName("Type1C"));
                }
                catch (PdfException e) {
                    Logger logger = LoggerFactory.getLogger(PdfTrueTypeFont.class);
                    logger.error(e.getMessage());
                    fontStream = null;
                }
            } else {
                fontFileName = PdfName.FontFile2;
                TreeSet<Integer> glyphs = new TreeSet<Integer>();
                for (int k = 0; k < this.shortTag.length; ++k) {
                    Glyph glyph;
                    if (this.shortTag[k] == 0) continue;
                    int uni = this.fontEncoding.getUnicode(k);
                    Glyph glyph2 = glyph = uni > -1 ? this.fontProgram.getGlyph(uni) : this.fontProgram.getGlyphByCode(k);
                    if (glyph == null) continue;
                    glyphs.add(glyph.getCode());
                }
                ((TrueTypeFont)this.getFontProgram()).updateUsedGlyphs(glyphs, this.subset, this.subsetRanges);
                try {
                    byte[] fontStreamBytes = this.subset || ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() > 0 ? ((TrueTypeFont)this.getFontProgram()).getSubset(glyphs, this.subset) : ((TrueTypeFont)this.getFontProgram()).getFontStreamBytes();
                    fontStream = this.getPdfFontStream(fontStreamBytes, new int[]{fontStreamBytes.length});
                }
                catch (PdfException e) {
                    Logger logger = LoggerFactory.getLogger(PdfTrueTypeFont.class);
                    logger.error(e.getMessage());
                    fontStream = null;
                }
            }
            if (fontStream != null) {
                fontDescriptor.put(fontFileName, fontStream);
                if (fontStream.getIndirectReference() != null) {
                    fontStream.flush();
                }
            }
        }
    }

    @Override
    protected boolean isBuiltInFont() {
        return this.fontProgram instanceof Type1Font && ((Type1Font)this.fontProgram).isBuiltInFont();
    }
}

