/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.counter.data;

import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.kernel.counter.data.EventDataHandler;
import java.util.Comparator;
import org.slf4j.LoggerFactory;

public final class EventDataHandlerUtil {
    private EventDataHandlerUtil() {
    }

    public static <T, V extends EventData<T>> void registerProcessAllShutdownHook(final EventDataHandler<T, V> dataHandler) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    dataHandler.tryProcessRest();
                }
            });
        }
        catch (SecurityException security) {
            LoggerFactory.getLogger(EventDataHandlerUtil.class).error("Unable to register event data handler shutdown hook because of security reasons.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T, V extends EventData<T>> void registerTimedProcessing(final EventDataHandler<T, V> dataHandler) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(dataHandler.getWaitTime().getTime());
                        dataHandler.tryProcessNextAsync(false);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception any) {
                    LoggerFactory.getLogger(EventDataHandlerUtil.class).error("Unexpected exception encountered in service thread. Shutting it down.", any);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static class BiggerCountComparator<T, V extends EventData<T>>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            return Long.compare(((EventData)o2).getCount(), ((EventData)o1).getCount());
        }
    }
}

