/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRgb
extends Color {
    public static final Color BLACK = new DeviceRgb(0, 0, 0);
    public static final Color WHITE = new DeviceRgb(255, 255, 255);
    public static final Color RED = new DeviceRgb(255, 0, 0);
    public static final Color GREEN = new DeviceRgb(0, 255, 0);
    public static final Color BLUE = new DeviceRgb(0, 0, 255);
    private static final long serialVersionUID = 7172400358137528030L;

    public DeviceRgb(int r, int g, int b) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public DeviceRgb(float r, float g, float b) {
        float[] fArray = new float[3];
        float f = r > 1.0f ? 1.0f : (fArray[0] = r > 0.0f ? r : 0.0f);
        float f2 = g > 1.0f ? 1.0f : (fArray[1] = g > 0.0f ? g : 0.0f);
        fArray[2] = b > 1.0f ? 1.0f : (b > 0.0f ? b : 0.0f);
        super(new PdfDeviceCs.Rgb(), fArray);
        if (r > 1.0f || r < 0.0f || g > 1.0f || g < 0.0f || b > 1.0f || b < 0.0f) {
            Logger LOGGER = LoggerFactory.getLogger(DeviceRgb.class);
            LOGGER.warn("Some of colorant intensities are invalid: they are bigger than 1 or less than 0. We will force them to become 1 or 0 respectively.");
        }
    }

    public DeviceRgb(java.awt.Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
        if (color.getAlpha() != 255) {
            Logger LOGGER = LoggerFactory.getLogger(DeviceRgb.class);
            LOGGER.warn(MessageFormatUtil.format("Alpha channel {0} was ignored during color creation. Note that opacity can be achieved in some places by using 'setOpacity' method or 'TransparentColor' class", color.getAlpha()));
        }
    }

    public DeviceRgb() {
        this(0.0f, 0.0f, 0.0f);
    }

    public static DeviceRgb makeLighter(DeviceRgb rgbColor) {
        float b;
        float g;
        float r = rgbColor.getColorValue()[0];
        float v = Math.max(r, Math.max(g = rgbColor.getColorValue()[1], b = rgbColor.getColorValue()[2]));
        if (v == 0.0f) {
            return new DeviceRgb(84, 84, 84);
        }
        float multiplier = Math.min(1.0f, v + 0.33f) / v;
        r = multiplier * r;
        g = multiplier * g;
        b = multiplier * b;
        return new DeviceRgb(r, g, b);
    }

    public static DeviceRgb makeDarker(DeviceRgb rgbColor) {
        float r = rgbColor.getColorValue()[0];
        float g = rgbColor.getColorValue()[1];
        float b = rgbColor.getColorValue()[2];
        float v = Math.max(r, Math.max(g, b));
        float multiplier = Math.max(0.0f, (v - 0.33f) / v);
        r = multiplier * r;
        g = multiplier * g;
        b = multiplier * b;
        return new DeviceRgb(r, g, b);
    }
}

