/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.xbrljson.convert;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.logging.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DomToJson {
    private static final Logger log = Logger.getLogger(DomToJson.class.toString());

    public JSONObject convertXmlJsonData(String xmlValue) {
        if (StrUtil.isBlank(xmlValue)) {
            return null;
        }
        Document document = null;
        JSONObject jsonObject = null;
        try {
            document = DocumentHelper.parseText(xmlValue);
            Element rootNode = document.getRootElement();
            if (rootNode == null) {
                return null;
            }
            jsonObject = new JSONObject();
            this.readJsonData(rootNode, jsonObject);
        }
        catch (DocumentException e) {
            log.info(e.toString());
        }
        return jsonObject;
    }

    private void readJsonData(Element element, JSONObject jsonObject) {
        if (element == null || jsonObject == null) {
            return;
        }
        List<Attribute> attrList = element.attributes();
        if (attrList != null && attrList.size() > 0) {
            String attrValue = null;
            for (Attribute attr : attrList) {
                attrValue = attr.getValue();
                if (StrUtil.isBlank(attrValue)) continue;
                jsonObject.put("@" + attr.getName(), (Object)attrValue);
            }
        }
        List<Element> childList = element.elements();
        String textValue = element.getText();
        if (!StrUtil.isBlank(textValue)) {
            jsonObject.put(element.getName(), (Object)textValue);
        }
        if (childList == null || childList.size() == 0) {
            return;
        }
        String itemName = null;
        List<Element> childNodeList = null;
        for (Element item : childList) {
            itemName = item.getName();
            childNodeList = item.elements();
            attrList = item.attributes();
            if (childNodeList == null || childNodeList.size() == 0) {
                textValue = item.getText();
                if (!StrUtil.isBlank(textValue)) {
                    jsonObject.put(itemName, (Object)textValue);
                }
                if (attrList == null) continue;
                String attrValue = null;
                for (Attribute attr : attrList) {
                    attrValue = attr.getValue();
                    if (StrUtil.isBlank(attrValue)) continue;
                    jsonObject.put("@" + attr.getName(), (Object)attrValue);
                }
                continue;
            }
            JSONObject childJson = new JSONObject();
            this.readJsonData(item, childJson);
            Object o = jsonObject.get(itemName);
            if (o != null) {
                JSONArray jsonArray = null;
                if (o instanceof JSONObject) {
                    JSONObject jsonObj = (JSONObject)o;
                    jsonObject.remove(itemName);
                    jsonArray = new JSONArray();
                    jsonArray.add(jsonObj);
                    jsonArray.add(childJson);
                }
                if (o instanceof JSONArray) {
                    jsonArray = (JSONArray)o;
                    jsonArray.add(childJson);
                }
                jsonObject.put(itemName, (Object)jsonArray);
                continue;
            }
            if (childJson == null || childJson.isEmpty()) continue;
            jsonObject.put(itemName, (Object)childJson);
        }
    }
}

