/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.verify;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;

public class PDFValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String PDFSignVerify(File pdfFile) {
        JSONObject jsonObject = new JSONObject();
        PDDocument document = null;
        try {
            RandomAccessBufferedFileInputStream raFile = new RandomAccessBufferedFileInputStream(pdfFile);
            PDFParser parser = new PDFParser(raFile);
            parser.setLenient(false);
            parser.parse();
            document = parser.getPDDocument();
            if (document.getSignatureDictionaries().size() == 0) {
                jsonObject.put("Errcode", (Object)"001");
                jsonObject.put("Errmsg", (Object)"\u6ca1\u6709\u7b7e\u7ae0");
                String string = jsonObject.toJSONString();
                return string;
            }
            for (PDSignature sig : document.getSignatureDictionaries()) {
                COSDictionary sigDict = sig.getCOSObject();
                int[] byteRange = sig.getByteRange();
                COSString contents1 = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
                if (byteRange.length != 4) {
                    jsonObject.put("Errcode", (Object)"002");
                    jsonObject.put("Errmsg", (Object)"\u7b7e\u540d\u5b57\u8282\u8303\u56f4\u5fc5\u987b\u67094\u4e2a\u9879\u76ee");
                    String string = jsonObject.toJSONString();
                    return string;
                }
                int contentLen = contents1.getString().length() * 2 + 2;
                if (byteRange[0] == 0 && byteRange[1] + contentLen == byteRange[2]) continue;
                jsonObject.put("Errcode", (Object)"003");
                jsonObject.put("Errmsg", (Object)"\u7b7e\u540d\u4e0d\u6db5\u76d6\u6574\u4e2a\u6587\u4ef6");
                String string = jsonObject.toJSONString();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject = new JSONObject();
            jsonObject.put("Errcode", (Object)"000");
            jsonObject.put("Errmsg", (Object)"\u7b7e\u540d\u65e0\u6cd5\u8bc6\u522b");
            String string = jsonObject.toJSONString();
            return string;
        }
        finally {
            try {
                if (document != null) {
                    document.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        jsonObject.put("Errcode", (Object)"0");
        return jsonObject.toJSONString();
    }
}

