/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import cn.com.szhtkj.enums.TicketEnum;
import cn.com.szhtkj.tools.FileTool;
import cn.com.szhtkj.tools.QRCodeTool;
import cn.com.szhtkj.tools.UUIDTool;
import cn.com.szhtkj.tools.ZipTool;
import cn.hutool.core.util.StrUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PdfTool {
    private static final String DEFAULT_ISSUER_XBRL_FILENAME = "voucher_issuer.xbrl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractXBRL(String pdfFilePath, String outputFilePath) throws IOException {
        File xbrlFile = null;
        File pdfFile = new File(pdfFilePath);
        PDDocument document = null;
        try {
            document = PDDocument.load(pdfFile);
            PDDocumentInformation info = document.getDocumentInformation();
            String xbrlStr = info.getCOSObject().getString("hidexml");
            if (StrUtil.isBlank(xbrlStr)) {
                File file = xbrlFile;
                return file;
            }
            xbrlStr = xbrlStr.replaceAll("\n", "");
            byte[] xbrlByte = ZipTool.uncompress(xbrlStr);
            xbrlStr = new String(xbrlByte);
            String fileName = null;
            fileName = xbrlStr.contains("CZ-EI") ? (xbrlStr.contains("\u975e\u7a0e\u6536\u5165\u7edf\u4e00\u7968\u636e") ? TicketEnum.NTREV_GPM_ISSUER.getConfigId() + ".xml" : TicketEnum.FINANCIAL_ELECTRONIC.getConfigId() + ".xml") : "xbrl.xml";
            outputFilePath = StrUtil.isBlank(outputFilePath) ? System.getProperty("java.io.tmpdir") + File.separator + "xbrl" + File.separator + "xbrl_" + UUIDTool.uuid() + File.separator + fileName : outputFilePath + File.separator + fileName;
            xbrlFile = new File(outputFilePath);
            FileTool.writeStringToFile(xbrlFile, xbrlStr);
        }
        finally {
            try {
                document.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return xbrlFile;
    }

    private static File extractFiles(Map<String, PDComplexFileSpecification> names, String attachName) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            String filename = fileSpec.getFile();
            if (!attachName.equals(filename)) continue;
            PDEmbeddedFile embeddedFile = PdfTool.getEmbeddedFile(fileSpec);
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "temp" + File.separator + UUIDTool.uuid() + "_temp" + File.separator + attachName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(embeddedFile.toByteArray());
            fos.close();
            return file;
        }
        return null;
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String identificationQRCode(File file) {
        PDDocument document = null;
        try {
            BufferedImage bufferedImage;
            BufferedImage imageQr;
            COSName objectName;
            PDXObject xobject;
            document = PDDocument.load(file);
            PDPageTree allPages = document.getDocumentCatalog().getPages();
            PDPage page = allPages.get(0);
            PDResources resources = page.getResources();
            Iterator<COSName> cosNames = resources.getXObjectNames().iterator();
            String result = "";
            while (!(!cosNames.hasNext() || (xobject = resources.getXObject(objectName = cosNames.next())) instanceof PDImageXObject && (imageQr = ((PDImageXObject)xobject).getImage()).getHeight() == imageQr.getWidth() && StrUtil.isNotEmpty(result = QRCodeTool.extractImages(bufferedImage = QRCodeTool.zoomInImage(imageQr, 5))))) {
            }
            String string = result;
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

