/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import api.info.AjaxResult;
import api.info.QRCodeInfo;
import api.info.VoucherFileInfo;
import api.info.VoucherReceiveInfo;
import cn.com.szhtkj.enums.FileType;
import cn.com.szhtkj.enums.TicketEnum;
import cn.com.szhtkj.tools.OfdTool;
import cn.com.szhtkj.tools.PdfTool;
import cn.com.szhtkj.tools.QRCodeTool;
import cn.com.szhtkj.tools.ZipTool;
import cn.com.szhtkj.verify.PDFValidator;
import cn.com.szhtkj.xbrljson.convert.DomToJson;
import cn.com.szhtkj.xbrljson.convert.JsonToXbrl;
import cn.com.szhtkj.xbrljson.convert.XbrlToJson;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileTool {
    private static final Log log = LogFactory.getLog(FileTool.class);
    private static final JsonToXbrl JTX = new JsonToXbrl();
    private static final DomToJson DTJ = new DomToJson();
    private static final XbrlToJson XTJ = new XbrlToJson();

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileTool.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2ByteArray(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream stream = null;
        ByteArrayOutputStream out = null;
        try {
            int n;
            stream = new FileInputStream(file);
            out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                stream.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileString(String filename) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(new File(filename).getAbsoluteFile()));){
            String s;
            while ((s = in.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Boolean writeStringToFile(File file, String dataStr) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                boolean newFile = file.createNewFile();
                if (!newFile) {
                    return false;
                }
            }
            byte[] bytes = dataStr.getBytes();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
            fos.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    public static FileType getFileType(File file) throws Exception {
        if (Objects.isNull(file) || !file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        FileType fileType = null;
        String fileNameLower = file.getName().toLowerCase();
        fileType = fileNameLower.endsWith(FileType.OFD.getSuffix()) ? FileType.OFD : (fileNameLower.endsWith(FileType.PDF.getSuffix()) ? FileType.PDF : (fileNameLower.endsWith(FileType.ZIP.getSuffix()) ? FileType.ZIP : (fileNameLower.endsWith(FileType.XML.getSuffix()) ? FileType.XML : FileType.OTHER)));
        return fileType;
    }

    public static String getConfigIdFromXbrlFile(File xbrlFile) {
        String configId = "";
        String xbrlStr = FileTool.readFileString(xbrlFile.getPath());
        for (TicketEnum item : TicketEnum.values()) {
            if (!xbrlStr.contains(item.getKey())) continue;
            configId = item.getConfigId();
            break;
        }
        return configId;
    }

    public static AjaxResult verificationSignature(String filePath) throws Exception {
        File file = new File(filePath);
        if (Objects.isNull(file) || !file.exists()) {
            return AjaxResult.error("\u9a8c\u7b7e\u5931\u8d25", (Object)"\u8def\u5f84\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        AjaxResult result = null;
        String fileName = file.getName();
        log.info("\u6587\u4ef6\u540d\uff1a" + fileName);
        Boolean verification = null;
        FileType fileType = FileTool.getFileType(file);
        if (fileType.equals((Object)FileType.OFD)) {
            String resultOfdYq = OfdTool.verificationSignature(file);
            log.info("\u9a8c\u7b7e\u7ed3\u679c\uff1a" + resultOfdYq);
            JSONObject json = JSONObject.parseObject(resultOfdYq);
            result = !"0".equals(json.get("Errcode").toString()) ? AjaxResult.error("\u9a8c\u7b7e\u5931\u8d25", (Object)json.getString("Errmsg")) : AjaxResult.success("\u9a8c\u7b7e\u6210\u529f", "\u9a8c\u7b7e\u901a\u8fc7");
        } else if (fileType.equals((Object)FileType.PDF)) {
            String resultPdfYq = PDFValidator.PDFSignVerify(file);
            log.info("\u9a8c\u7b7e\u7ed3\u679c\uff1a" + resultPdfYq);
            JSONObject json = JSONObject.parseObject(resultPdfYq);
            result = !"0".equals(json.get("Errcode").toString()) ? AjaxResult.error("\u9a8c\u7b7e\u5931\u8d25", (Object)json.getString("Errmsg")) : AjaxResult.success("\u9a8c\u7b7e\u6210\u529f", "\u9a8c\u7b7e\u901a\u8fc7");
        } else if (fileType.equals((Object)FileType.ZIP)) {
            verification = ZipTool.verificationSignature(file);
            log.info("\u9a8c\u7b7e\u7ed3\u679c\uff1a" + verification);
            result = verification.booleanValue() ? AjaxResult.success("\u9a8c\u7b7e\u6210\u529f", "\u9a8c\u7b7e\u901a\u8fc7") : AjaxResult.success("\u9a8c\u7b7e\u5931\u8d25", "\u9a8c\u7b7e\u672a\u901a\u8fc7");
        } else {
            result = AjaxResult.error("\u9a8c\u7b7e\u5931\u8d25", (Object)"\u4ec5\u652f\u6301ofd/zip\u51ed\u8bc1\u6587\u4ef6\u9a8c\u7b7e");
        }
        return result;
    }

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath, String outputFilePath) throws Exception {
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        log.info("\u53c2\u6570ofdFilePath(OFD\u6587\u4ef6\u8def\u5f84)\uff1a" + ofdFilePath);
        log.info("\u53c2\u6570outputFilePath(XBRL\u5b58\u50a8\u8def\u5f84)\uff1a" + outputFilePath);
        File xbrlFile = OfdTool.extractXBRL(ofdFilePath, outputFilePath);
        if (Objects.isNull(xbrlFile)) {
            throw new Exception("xbrl\u6587\u4ef6\u4e3a\u7a7a");
        }
        voucherFileInfo.setXbrlFilePath(xbrlFile.getPath());
        String configId = FileTool.getConfigIdFromXbrlFile(xbrlFile);
        log.info("configId\uff1a" + configId);
        voucherFileInfo.setVoucherType(configId);
        return voucherFileInfo;
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath, String outputFilePath) throws Exception {
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        log.info("\u53c2\u6570pdfFilePath(PDF\u6587\u4ef6\u8def\u5f84)\uff1a" + pdfFilePath);
        log.info("\u53c2\u6570outputFilePath(XBRL\u5b58\u50a8\u8def\u5f84)\uff1a" + outputFilePath);
        File xbrlFile = PdfTool.extractXBRL(pdfFilePath, outputFilePath);
        if (Objects.isNull(xbrlFile)) {
            throw new Exception("xbrl\u6587\u4ef6\u4e3a\u7a7a");
        }
        voucherFileInfo.setXbrlFilePath(xbrlFile.getPath());
        String configId = FileTool.getConfigIdFromXbrlFile(xbrlFile);
        log.info("configId\uff1a" + configId);
        voucherFileInfo.setVoucherType(configId);
        return voucherFileInfo;
    }

    public static VoucherFileInfo extractXBRLFromZIP(String zipFilePath, String outputFilePath) throws Exception {
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        log.info("\u53c2\u6570zipFilePath(ZIP\u6587\u4ef6\u8def\u5f84)\uff1a" + zipFilePath);
        log.info("\u53c2\u6570outputFilePath(XBRL\u5b58\u50a8\u8def\u5f84)\uff1a" + outputFilePath);
        File xbrlFile = ZipTool.extractXBRL(zipFilePath, outputFilePath);
        if (Objects.isNull(xbrlFile)) {
            throw new Exception("xbrl\u6587\u4ef6\u4e3a\u7a7a");
        }
        voucherFileInfo.setXbrlFilePath(xbrlFile.getPath());
        String configId = FileTool.getConfigIdFromXbrlFile(xbrlFile);
        log.info("configId\uff1a" + configId);
        voucherFileInfo.setVoucherType(configId);
        return voucherFileInfo;
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return JTX.convertXbrlXml(jsonValue, configId);
    }

    public static JSONObject xml2Json(String xbrlXml) {
        return DTJ.convertXmlJsonData(xbrlXml);
    }

    public static JSONObject xml2Json(String xbrlXml, String configId) {
        return XTJ.convertXbrlJsonData(xbrlXml, configId);
    }

    public static VoucherReceiveInfo receiveVoucher(String filePath) throws Exception {
        VoucherReceiveInfo voucherReceiveInfo = new VoucherReceiveInfo();
        File file = new File(filePath);
        if (Objects.isNull(file) || !file.exists()) {
            throw new Exception("\u8def\u5f84\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String fileName = file.getName();
        log.info("\u6587\u4ef6\u540d\uff1a" + fileName);
        String configId = null;
        File xbrlFile = null;
        String qrInfo = null;
        FileType fileType = FileTool.getFileType(file);
        if (fileType.equals((Object)FileType.OFD)) {
            xbrlFile = OfdTool.extractXBRL(filePath, "");
            qrInfo = OfdTool.identificationQRCode(file);
        } else if (fileType.equals((Object)FileType.PDF)) {
            xbrlFile = PdfTool.extractXBRL(filePath, "");
            qrInfo = PdfTool.identificationQRCode(file);
        } else if (fileType.equals((Object)FileType.ZIP)) {
            xbrlFile = ZipTool.extractXBRL(filePath, "");
        } else if (fileType.equals((Object)FileType.XML)) {
            configId = FileTool.getConfigIdFromXml(filePath);
            if (Objects.isNull(configId)) {
                throw new Exception("\u4e0d\u662f\u6807\u51c6\u7684XML\u51ed\u8bc1\u6587\u4ef6");
            }
        } else {
            throw new Exception("\u4ec5\u652f\u6301ofd/pdf/zip/xml\u51ed\u8bc1\u6587\u4ef6\u63a5\u6536");
        }
        if (!fileType.equals((Object)FileType.XML) && Objects.nonNull(xbrlFile) && xbrlFile.exists()) {
            configId = FileTool.getConfigIdFromXbrlFile(xbrlFile);
            FileTool.deleteDir(xbrlFile.getParentFile());
        }
        QRCodeInfo qrCodeInfo = QRCodeTool.getQRCodeInfo(qrInfo);
        if (StrUtil.isBlank(configId) && Objects.nonNull(qrCodeInfo)) {
            if (Objects.toString(qrCodeInfo.getKind(), "").contains("CZ-EI")) {
                configId = TicketEnum.FINANCIAL_ELECTRONIC.getConfigId();
            } else if ("31".equals(qrCodeInfo.getKind()) || "32".equals(qrCodeInfo.getKind())) {
                configId = TicketEnum.DIGITAL_ELECTRONIC.getConfigId();
            }
        } else if (StrUtil.isBlank(configId) && Objects.isNull(qrCodeInfo)) {
            throw new Exception("\u63a5\u6536\u5931\u8d25");
        }
        voucherReceiveInfo.setQrCodeInfo(qrCodeInfo);
        voucherReceiveInfo.setVoucherType(configId);
        return voucherReceiveInfo;
    }

    private static String getConfigIdFromXml(String filePath) {
        String configId = null;
        String xmlStr = FileTool.readFileString(filePath);
        String eIid = Objects.toString(StrUtil.subBetween(xmlStr, "<EIid>", "</EIid>"), "").trim();
        if (eIid.length() >= 20) {
            configId = TicketEnum.DIGITAL_ELECTRONIC.getConfigId();
        }
        return configId;
    }
}

