/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.gm.sm2strut;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public final class ContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private ASN1Encodable content;

    public ContentInfo(ASN1ObjectIdentifier contentType, ASN1Encodable content) {
        this.contentType = contentType;
        this.content = content;
    }

    public ContentInfo(ASN1Sequence seq) {
        this.contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            ASN1TaggedObject tagged = (ASN1TaggedObject)seq.getObjectAt(1);
            if (!tagged.isExplicit() || tagged.getTagNo() != 0) {
                throw new IllegalArgumentException("content \u65e0\u6cd5\u89e3\u6790");
            }
            this.content = tagged.getObject();
        }
    }

    public static ContentInfo getInstance(Object obj) {
        if (obj instanceof ContentInfo) {
            return (ContentInfo)obj;
        }
        if (obj != null) {
            return new ContentInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public ContentInfo setContentType(ASN1ObjectIdentifier contentType) {
        this.contentType = contentType;
        return this;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    public ContentInfo setContent(ASN1Encodable content) {
        this.content = content;
        return this;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.contentType);
        if (this.content != null) {
            v.add(new DERTaggedObject(0, this.content));
        }
        return new DERSequence(v);
    }
}

