/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi;

import api.VoucherFileInfo;
import api.VoucherFileUtil;
import com.alibaba.fastjson.JSONObject;
import com.bosssoft.tool.util.PdfExtractor;
import com.inspur.gs.xbrl.tools.webapi.CommUtils;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISCommonService;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISFileUtils;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISImageCommonUtil;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.EInvoice;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISXbrlXmlUtil;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISZipUtil;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.XBRLType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EISTools {
    private static final Log log = LogFactory.getLog(EISTools.class);

    public EISTools() {
        try {
            String filePath = CommUtils.getFilePath() + "/temp";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String extractXBRLFile(String xbrlXml, String type) {
        String retMsg = "";
        try {
            XBRLType xbrlType = EISXbrlXmlUtil.getXbrlConfigId(type, xbrlXml);
            EInvoice eInvoice = EISCommonService.formatEInvoice(xbrlXml, null, xbrlType);
            retMsg = JSONObject.toJSONString((Object)eInvoice);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return retMsg;
    }

    public String getczdzpjfrompdf(byte[] stringToByte) {
        String retMsg = "";
        try {
            byte[] xmlb = PdfExtractor.mainXml((byte[])stringToByte);
            EInvoice eInvoice = EISCommonService.formatEInvoice(null, EISImageCommonUtil.byteToInputStream(xmlb), XBRLType.czdzpj);
            retMsg = JSONObject.toJSONString((Object)eInvoice);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return retMsg;
    }

    public String getinvoicefromxml(byte[] stringToByte) {
        String retMsg = "";
        try {
            EInvoice eInvoice = EISCommonService.formatEInvoice(null, EISImageCommonUtil.byteToInputStream(stringToByte), XBRLType.FullElectricInvoice);
            retMsg = JSONObject.toJSONString((Object)eInvoice);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return retMsg;
    }

    public String getinvoicefromofd(byte[] stringToByte) {
        String retMsg = "";
        try {
            String fileName = CommUtils.getFilePath() + "/temp/" + CommUtils.genGUID() + ".ofd";
            try {
                FileOutputStream out = new FileOutputStream(fileName);
                ((OutputStream)out).write(stringToByte);
                out.flush();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
                retMsg = e.getMessage();
                return "{\"code\":\"1\",\"mess\":\"" + retMsg + "\"}";
            }
            VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromOFD((String)fileName);
            String xbrlXml = new String(CommUtils.fileToByte(voucherFileInfo.getXbrlFilePath()), "utf-8");
            String type = voucherFileInfo.getVoucherType();
            XBRLType xbrlType = EISXbrlXmlUtil.getXbrlConfigId(type, xbrlXml);
            EInvoice eInvoice = EISCommonService.formatEInvoice(xbrlXml, null, xbrlType);
            eInvoice.PZType = xbrlType.toString() + "_ofd";
            retMsg = JSONObject.toJSONString((Object)eInvoice);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return retMsg;
    }

    public String getinvoicefrompdf(byte[] stringToByte) {
        String retMsg = "";
        try {
            String fileName = CommUtils.getFilePath() + "/temp/" + CommUtils.genGUID() + ".pdf";
            try {
                FileOutputStream out = new FileOutputStream(fileName);
                ((OutputStream)out).write(stringToByte);
                out.flush();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
                retMsg = e.getMessage();
                return "{\"code\":\"1\",\"mess\":\"" + retMsg + "\"}";
            }
            VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromPDF((String)fileName);
            String xbrlXml = new String(CommUtils.fileToByte(voucherFileInfo.getXbrlFilePath()), "utf-8");
            String type = voucherFileInfo.getVoucherType();
            XBRLType xbrlType = EISXbrlXmlUtil.getXbrlConfigId(type, xbrlXml);
            EInvoice eInvoice = EISCommonService.formatEInvoice(xbrlXml, null, xbrlType);
            eInvoice.PZType = xbrlType.toString();
            retMsg = JSONObject.toJSONString((Object)eInvoice);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return retMsg;
    }

    public String signatureVerify(byte[] stringToByte, String filename) {
        String retMsg = null;
        try {
            boolean signatureVerify;
            block8: {
                byte[] signedData;
                byte[] sourceData;
                ByteArrayInputStream inputStream;
                String fileext;
                block7: {
                    fileext = filename.substring(filename.lastIndexOf("."));
                    inputStream = new ByteArrayInputStream(stringToByte);
                    sourceData = null;
                    signedData = null;
                    signatureVerify = false;
                    if (!fileext.toLowerCase().contains("zip")) break block7;
                    Map<String, Object> resultMap = EISZipUtil.getSignFromZip(inputStream);
                    sourceData = (byte[])resultMap.get("signxml.xml");
                    signedData = (byte[])resultMap.get("signdata.sign");
                    if (sourceData == null || signedData == null) break block8;
                    signatureVerify = EISFileUtils.signatureVerify(sourceData, signedData, null);
                    break block8;
                }
                if (fileext.toLowerCase().contains("ofd")) {
                    List<Map<String, Object>> relsultList = EISZipUtil.getSignFromOFD(inputStream);
                    for (Map<String, Object> resultMap : relsultList) {
                        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                            String fileName = entry.getKey();
                            if (fileName.contains("@signature@")) {
                                sourceData = (byte[])entry.getValue();
                                continue;
                            }
                            if (!fileName.contains("@signedvalue@")) continue;
                            signedData = (byte[])entry.getValue();
                        }
                        if (sourceData == null || signedData == null || (signatureVerify = EISFileUtils.signatureVerify(sourceData, signedData, inputStream))) continue;
                        break;
                    }
                }
            }
            if (!signatureVerify) {
                retMsg = "\u9a8c\u7b7e\u5931\u8d25\uff01";
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return retMsg;
    }
}

