/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder;

import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.Buyer;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.EInvoice;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.GoodsInfo;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.GoodsInfos;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.Seller;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFullInvoiceExtractor {
    Logger log = LoggerFactory.getLogger(XmlFullInvoiceExtractor.class);

    public EInvoice extract(InputStream inputStream) {
        HashMap<String, Object> fullInvoiceMap = new HashMap<String, Object>();
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(inputStream);
            Element fullInvoiceStore = document.getRootElement();
            this.readElement(fullInvoiceStore, fullInvoiceMap);
            return this.mapDataToElectronicInvoiceInfo(fullInvoiceMap);
        }
        catch (Exception e) {
            this.log.error("XmlFullInvoiceExtractor err:" + e);
            return null;
        }
    }

    public EInvoice extractCzdzpj(InputStream inputStream) {
        HashMap<String, Object> fullInvoiceMap = new HashMap<String, Object>();
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(inputStream);
            Element fullInvoiceStore = document.getRootElement();
            this.readElement(fullInvoiceStore, fullInvoiceMap);
            return this.mapCzdzpjDataToElectronicInvoiceInfo(fullInvoiceMap);
        }
        catch (Exception e) {
            this.log.error("XmlFullInvoiceExtractor err:" + e);
            return null;
        }
    }

    private void readElement(Element node, Map<String, Object> fullInvoiceMap) {
        boolean isNodes;
        boolean bl = isNodes = node.elements().size() > 0;
        if (isNodes) {
            Iterator itt = node.elementIterator();
            while (itt.hasNext()) {
                Element nodet = (Element)itt.next();
                this.readElement(nodet, fullInvoiceMap);
            }
        } else if (!fullInvoiceMap.containsKey(node.getPath())) {
            fullInvoiceMap.put(node.getPath(), node.getStringValue());
        } else {
            int i = 1;
            String pathName = node.getPath();
            String name = node.getPath();
            while (fullInvoiceMap.containsKey(pathName)) {
                pathName = name + "@@" + i;
                ++i;
            }
            fullInvoiceMap.put(pathName, node.getStringValue());
        }
    }

    private EInvoice mapCzdzpjDataToElectronicInvoiceInfo(Map<String, Object> fullInvoiceMap) {
        EInvoice invoice = null;
        if (fullInvoiceMap != null) {
            invoice = new EInvoice();
            String LabelName = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/MainExt/OrgType");
            invoice.TypeCode = "40";
            invoice.InvoiceNo = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/EInvoiceNumber");
            invoice.InvoiceCode = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/EInvoiceCode");
            invoice.InvoiceDate = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/IssueDate");
            Buyer buyer = new Buyer();
            buyer.BuyerName = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/PayerParty/PayerPartyName");
            buyer.BuyerTaxID = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/PayerParty/PayerPartyCode");
            buyer.BuyerFinancialAccount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/PayerParty/PayerOpBk") + fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/PayerParty/PayerAcct");
            invoice.buyer = buyer;
            Seller seller = new Seller();
            seller.SellerFinancialAccount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/InvoicingParty/RecOpBk") + fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/InvoicingParty/RecAcct");
            seller.SellerTaxID = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/InvoicingParty/InvoicingPartyCode");
            seller.SellerName = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/InvoicingParty/InvoicingPartyName");
            invoice.Note = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/Remark");
            invoice.TaxInclusiveTotalAmount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/TotalAmount");
            invoice.TaxExclusiveTotalAmount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Main/TotalAmount");
            invoice.TaxTotalAmount = "0";
            GoodsInfos goodsInfos = new GoodsInfos();
            goodsInfos.goodsInfos = new ArrayList<GoodsInfo>();
            GoodsInfo commodities1 = new GoodsInfo();
            commodities1.Item = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemName");
            commodities1.Amount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemAmount");
            commodities1.Quantity = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemQuantity");
            commodities1.MeasurementDimension = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemStd");
            commodities1.Specification = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemUnit");
            goodsInfos.goodsInfos.add(commodities1);
            int i = 1;
            while (fullInvoiceMap.containsKey("/EInvoice/EInvoiceData/Details/Item/ItemName@@" + i)) {
                commodities1 = new GoodsInfo();
                commodities1.Item = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemName@@" + i);
                commodities1.Amount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemAmount@@" + i);
                commodities1.Quantity = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemQuantity@@" + i);
                commodities1.MeasurementDimension = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemStd@@" + i);
                commodities1.Specification = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/Details/Item/ItemUnit@@" + i);
                goodsInfos.goodsInfos.add(commodities1);
                ++i;
            }
            invoice.goodsInfos = goodsInfos;
        }
        return invoice;
    }

    private EInvoice mapDataToElectronicInvoiceInfo(Map<String, Object> fullInvoiceMap) {
        EInvoice invoice = null;
        if (fullInvoiceMap != null) {
            invoice = new EInvoice();
            String LabelName1 = (String)fullInvoiceMap.get("/EInvoice/Header/InherentLabel/EInvoiceType/LabelName");
            String LabelName2 = (String)fullInvoiceMap.get("/EInvoice/Header/InherentLabel/GeneralOrSpecialVAT/LabelName");
            invoice.TypeCode = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(LabelName2) ? "06" : "05";
            invoice.InvoiceNo = (String)fullInvoiceMap.get("/EInvoice/TaxSupervisionInfo/InvoiceNumber");
            invoice.InvoiceDate = (String)fullInvoiceMap.get("/EInvoice/TaxSupervisionInfo/IssueTime");
            Buyer buyer = new Buyer();
            buyer.BuyerName = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BuyerInformation/BuyerName");
            buyer.BuyerTaxID = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BuyerInformation/BuyerIdNum");
            buyer.BuyerAddrTel = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BuyerInformation/BuyerAddr") + fullInvoiceMap.get("/EInvoice/EInvoiceData/BuyerInformation/BuyerTelNum");
            buyer.BuyerFinancialAccount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BuyerInformation/BuyerBankName") + fullInvoiceMap.get("/EInvoice/EInvoiceData/BuyerInformation/BuyerBankAccNum");
            invoice.buyer = buyer;
            Seller seller = new Seller();
            seller.SellerFinancialAccount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/SellerInformation/SellerBankName") + fullInvoiceMap.get("/EInvoice/EInvoiceData/SellerInformation/SellerBankAccNum");
            seller.SellerAddrTel = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/SellerInformation/SellerAddr") + fullInvoiceMap.get("/EInvoice/EInvoiceData/SellerInformation/SellerTelNum");
            seller.SellerTaxID = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/SellerInformation/SellerIdNum");
            seller.SellerName = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/SellerInformation/SellerName");
            invoice.Note = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/AdditionalInformation/Remark");
            invoice.TaxInclusiveTotalAmount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BasicInformation/TotalTax-includedAmount");
            invoice.TaxExclusiveTotalAmount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BasicInformation/TotalAmWithoutTax");
            invoice.TaxTotalAmount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/BasicInformation/TotalTaxAm");
            GoodsInfos goodsInfos = new GoodsInfos();
            goodsInfos.goodsInfos = new ArrayList<GoodsInfo>();
            GoodsInfo commodities1 = new GoodsInfo();
            commodities1.Item = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/ItemName");
            commodities1.TaxAmount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/ComTaxAm");
            commodities1.TaxScheme = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/TaxRate");
            commodities1.Amount = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/Amount");
            commodities1.Price = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/UnPrice");
            commodities1.Quantity = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/Quantity");
            commodities1.MeasurementDimension = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/MeaUnits");
            commodities1.Specification = (String)fullInvoiceMap.get("/EInvoice/EInvoiceData/IssuItemInformation/SpecMod");
            goodsInfos.goodsInfos.add(commodities1);
            invoice.goodsInfos = goodsInfos;
        }
        return invoice;
    }
}

