/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder;

import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISDomUtil;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISXMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EISZipUtil {
    public static final String docNS = "http://www.edrm.org.cn/schemas/package/2021";
    public static final String ofdDocNS = "http://www.ofdspec.org/2016";

    public static Map<String, Object> unOpg(InputStream iputStream) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> opgFileName = new HashMap<String, String>();
        HashMap<String, ByteArrayInputStream> inMap = new HashMap<String, ByteArrayInputStream>();
        ZipInputStream zis = new ZipInputStream(iputStream);
        ZipEntry nextEntry = zis.getNextEntry();
        while (nextEntry != null) {
            byte[] data;
            String name = nextEntry.getName();
            String ext = name.substring(name.lastIndexOf(".")).toLowerCase();
            if (name.equals("opg.xml")) {
                data = EISZipUtil.getByte(zis);
                String xmlValue = new String(data);
                data = (xmlValue = xmlValue.replace(":ofd", ":opg").replace("ofd:", "opg:")).getBytes();
                ByteArrayInputStream is = new ByteArrayInputStream(data);
                Document document = EISXMLUtil.getDocument(is);
                NodeList Nlist = document.getElementsByTagNameNS(docNS, "Components");
                if (Nlist.getLength() > 0) {
                    Node ComponentNode = Nlist.item(0);
                    List<Node> list = EISDomUtil.getElementsByTagNameNS(ComponentNode, docNS, "Component", "opg:");
                    for (Node tnode : list) {
                        NamedNodeMap Nmap = tnode.getAttributes();
                        String DocID = Nmap.getNamedItem("DocID").getNodeValue();
                        List<Node> tlist = EISDomUtil.getElementsByTagNameNS(tnode, docNS, "FileLoc", "opg:");
                        if (tlist.size() <= 0) continue;
                        String FileLoc = tlist.get(0).getTextContent();
                        opgFileName.put(FileLoc, DocID);
                    }
                }
            }
            if (ext.equals(".ofd")) {
                data = EISZipUtil.getByte(zis);
                ByteArrayInputStream is = new ByteArrayInputStream(data);
                inMap.put(name, is);
            }
            zis.closeEntry();
            nextEntry = zis.getNextEntry();
        }
        zis.close();
        iputStream.close();
        resultMap.put("opgFileName", opgFileName);
        resultMap.put("inMap", inMap);
        return resultMap;
    }

    public static byte[] unofd(InputStream iputStream) throws Exception {
        ZipInputStream zis = new ZipInputStream(iputStream);
        byte[] data = null;
        ZipEntry nextEntry = zis.getNextEntry();
        while (nextEntry != null) {
            String name = nextEntry.getName();
            if (name.contains("voucher_issuer.xbrl")) {
                data = EISZipUtil.getByte(zis);
            }
            zis.closeEntry();
            nextEntry = zis.getNextEntry();
        }
        zis.close();
        iputStream.close();
        return data;
    }

    public static InputStream unzip(InputStream iputStream) throws Exception {
        ZipInputStream zis = new ZipInputStream(iputStream);
        ByteArrayInputStream is = null;
        ZipEntry nextEntry = zis.getNextEntry();
        while (nextEntry != null) {
            String name = nextEntry.getName();
            if (name.contains("original_invoice")) {
                byte[] data = EISZipUtil.getByte(zis);
                is = new ByteArrayInputStream(data);
            }
            zis.closeEntry();
            nextEntry = zis.getNextEntry();
        }
        zis.close();
        iputStream.close();
        return is;
    }

    public static Map<String, Object> getSignFromZip(InputStream iputStream) throws Exception {
        ZipInputStream zis = new ZipInputStream(iputStream);
        String signName = "";
        HashMap<String, byte[]> fileMap = new HashMap<String, byte[]>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ZipEntry nextEntry = zis.getNextEntry();
        while (nextEntry != null) {
            String name = nextEntry.getName();
            String ext = name.substring(name.lastIndexOf(".")).toLowerCase();
            if (ext.contains("sign")) {
                signName = name;
            }
            byte[] data = EISZipUtil.getByte(zis);
            fileMap.put(name, data);
            zis.closeEntry();
            nextEntry = zis.getNextEntry();
        }
        zis.close();
        iputStream.close();
        if (signName != null && signName != "") {
            String tmpname = signName.substring(0, signName.lastIndexOf("."));
            if (fileMap.containsKey(tmpname + ".xml")) {
                byte[] signxml = (byte[])fileMap.get(tmpname + ".xml");
                resultMap.put("signxml.xml", signxml);
            }
            if (fileMap.containsKey(tmpname + ".sign")) {
                byte[] signdata = (byte[])fileMap.get(tmpname + ".sign");
                resultMap.put("signdata.sign", signdata);
            }
        }
        return resultMap;
    }

    public static List<Map<String, Object>> getSignFromOFD(InputStream iputStream) throws Exception {
        ZipInputStream zis = new ZipInputStream(iputStream);
        ArrayList<Map<String, Object>> resultLsit = new ArrayList<Map<String, Object>>();
        HashMap<String, byte[]> fileMap = new HashMap<String, byte[]>();
        ZipEntry nextEntry = zis.getNextEntry();
        while (nextEntry != null) {
            try {
                String name = nextEntry.getName().toLowerCase();
                byte[] data = EISZipUtil.getByte(zis);
                fileMap.put(name, data);
                zis.closeEntry();
                nextEntry = zis.getNextEntry();
            }
            catch (Exception ex) {
                nextEntry = null;
                ex.printStackTrace();
            }
        }
        zis.close();
        iputStream.close();
        byte[] data = (byte[])fileMap.get("ofd.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        Document document = EISXMLUtil.getDocument(inputStream);
        NodeList Nlist = document.getElementsByTagNameNS(ofdDocNS, "OFD");
        if (Nlist.getLength() > 0) {
            Node ComponentNode = Nlist.item(0);
            List<Node> list = EISDomUtil.getElementsByTagNameNS(ComponentNode, ofdDocNS, "DocBody", "ofd:");
            for (Node tnode : list) {
                List<Node> tlist = EISDomUtil.getElementsByTagNameNS(tnode, ofdDocNS, "Signatures", "ofd:");
                for (Node node : tlist) {
                    String signatures = node.getTextContent().toLowerCase();
                    if (signatures.startsWith("/")) {
                        signatures = signatures.substring(1);
                    }
                    System.out.println(signatures);
                    if (signatures == null || signatures == "") continue;
                    byte[] signaturedata = (byte[])fileMap.get(signatures);
                    ByteArrayInputStream signatureinputStream = new ByteArrayInputStream(signaturedata);
                    Document signaturedocument = EISXMLUtil.getDocument(signatureinputStream);
                    NodeList signatureNlist = signaturedocument.getElementsByTagNameNS(ofdDocNS, "Signatures");
                    for (int i = 0; i < signatureNlist.getLength(); ++i) {
                        Node signatureNode = signatureNlist.item(i);
                        List<Node> signaturelist = EISDomUtil.getElementsByTagNameNS(signatureNode, ofdDocNS, "Signature", "ofd:");
                        for (Node snote : signaturelist) {
                            HashMap<String, Object> resultMap = new HashMap<String, Object>();
                            NamedNodeMap Nmap = snote.getAttributes();
                            String signature = Nmap.getNamedItem("BaseLoc").getNodeValue();
                            if (signature != null && signature != "") {
                                File signaturesFile;
                                if ((signature = signature.toLowerCase()).startsWith("/")) {
                                    signature = signature.substring(1);
                                }
                                String signaturePath = signature;
                                if (!fileMap.containsKey(signature) && (signaturePath = (signaturesFile = new File(signatures)).getParent() + "/" + signature).startsWith("/")) {
                                    signaturePath = signaturePath.substring(1);
                                }
                                signaturePath = signaturePath.replace("\\", "/");
                                System.out.println(signaturePath);
                                if (fileMap.containsKey(signaturePath)) {
                                    byte[] xmlData = (byte[])fileMap.get(signaturePath);
                                    resultMap.put(signaturePath + "@signature@", xmlData);
                                    ByteArrayInputStream xmlStream = new ByteArrayInputStream(xmlData);
                                    Document xmldocument = EISXMLUtil.getDocument(xmlStream);
                                    NodeList xmlNlist = xmldocument.getElementsByTagNameNS(ofdDocNS, "Signature");
                                    for (int j = 0; j < xmlNlist.getLength(); ++j) {
                                        Node xmlNode = xmlNlist.item(i);
                                        List<Node> xmllist = EISDomUtil.getElementsByTagNameNS(xmlNode, ofdDocNS, "SignedValue", "ofd:");
                                        for (Node xnote : xmllist) {
                                            File signatureFile;
                                            String signedvaluePath;
                                            String signedvalue = xnote.getTextContent().toLowerCase();
                                            if ((signedvalue = signedvalue.toLowerCase()).startsWith("/")) {
                                                signedvalue = signedvalue.substring(1);
                                            }
                                            if (!fileMap.containsKey(signedvaluePath = signedvalue) && (signedvaluePath = (signatureFile = new File(signaturePath)).getParent() + "/" + signedvalue).startsWith("/")) {
                                                signedvaluePath = signedvaluePath.substring(1);
                                            }
                                            signedvaluePath = signedvaluePath.replace("\\", "/");
                                            System.out.println(signedvaluePath);
                                            resultMap.put(signedvaluePath + "@signedvalue@", fileMap.get(signedvaluePath));
                                        }
                                    }
                                }
                            }
                            resultLsit.add(resultMap);
                        }
                    }
                }
            }
        }
        return resultLsit;
    }

    public static byte[] getByte(InflaterInputStream zis) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] temp = new byte[1024];
            byte[] buf = null;
            int length = 0;
            while ((length = zis.read(temp, 0, 1024)) != -1) {
                bout.write(temp, 0, length);
            }
            buf = bout.toByteArray();
            bout.close();
            return buf;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

