/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder;

import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISValidate.MyOFDValidator;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISValidate.MyValidateContainer;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.MapValueComparator;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.SM2SignatureService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofdrw.converter.ImageMaker;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.sign.verify.OFDValidator;
import org.ofdrw.sign.verify.SignedDataValidateContainer;
import org.ofdrw.sign.verify.container.SESV1ValidateContainer;
import org.ofdrw.sign.verify.container.SESV4ValidateContainer;

public class EISFileUtils {
    private static final Log log = LogFactory.getLog(EISFileUtils.class);
    static String ofdpathlist = System.getProperty("user.dir") + "/eiscache/ofdlist";

    public static String mergePdf(List<InputStream> inputStreamList) throws Exception {
        String dstName = ofdpathlist + "/" + UUID.randomUUID().toString() + ".pdf";
        File file = new File(ofdpathlist);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream bos = new FileOutputStream(dstName);
        Document document = new Document();
        PdfCopy copy = new PdfCopy(document, (OutputStream)bos);
        document.open();
        for (InputStream is : inputStreamList) {
            PdfReader reader = new PdfReader(is);
            int pageTotal = reader.getNumberOfPages();
            for (int pageNo = 1; pageNo <= pageTotal; ++pageNo) {
                document.newPage();
                PdfImportedPage page = copy.getImportedPage(reader, pageNo);
                copy.addPage(page);
            }
            reader.close();
        }
        document.close();
        bos.close();
        return dstName;
    }

    public static Map<String, String> sortMapByValue(Map<String, String> oriMap) {
        if (oriMap == null || oriMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(oriMap.entrySet());
        Collections.sort(entryList, new MapValueComparator());
        Iterator iter = entryList.iterator();
        Map.Entry tmpEntry = null;
        while (iter.hasNext()) {
            tmpEntry = (Map.Entry)iter.next();
            sortedMap.put((String)tmpEntry.getKey(), (String)tmpEntry.getValue());
        }
        return sortedMap;
    }

    public static boolean signatureVerify(byte[] sourceData, byte[] signedData, InputStream ofdInputStream) throws Exception {
        SM2SignatureService sm2SignatureService = new SM2SignatureService();
        boolean result = false;
        try {
            result = sm2SignatureService.verify(sourceData, signedData);
        }
        catch (Throwable throwable) {
            result = false;
        }
        if (!result && ofdInputStream != null) {
            result = EISFileUtils.signatureVerifyOFD(ofdInputStream);
        }
        return result;
    }

    public static boolean signatureVerifyOFD(InputStream inputStream) throws Exception {
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        OFDReader reader = new OFDReader(inputStream);
        MyOFDValidator validator = new MyOFDValidator(reader);
        validator.setValidator(new MyValidateContainer());
        boolean result = validator.exeValidate();
        if (!result) {
            result = EISFileUtils.signatureVerifyOFD1(inputStream);
        }
        if (!result) {
            result = EISFileUtils.signatureVerifyOFD2(inputStream);
        }
        return result;
    }

    private static boolean signatureVerifyOFD1(InputStream inputStream) throws Exception {
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        try {
            OFDReader reader = new OFDReader(inputStream);
            OFDValidator validator = new OFDValidator(reader);
            validator.setValidator((SignedDataValidateContainer)new SESV1ValidateContainer());
            validator.exeValidate();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static boolean signatureVerifyOFD2(InputStream inputStream) throws Exception {
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        OFDReader reader = new OFDReader(inputStream);
        MyOFDValidator validator = new MyOFDValidator(reader);
        validator.setValidator((SignedDataValidateContainer)new SESV4ValidateContainer());
        return validator.exeValidate();
    }

    public static String toPng(InputStream stream) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        int dstHeight = 0;
        int dstWidth = 0;
        String resImage = "";
        try (OFDReader reader = new OFDReader(stream);){
            ImageMaker imageMaker = new ImageMaker(reader, 15);
            for (int i = 0; i < imageMaker.pageSize(); ++i) {
                BufferedImage image = imageMaker.makePage(i);
                images.add(image);
            }
            stream.close();
        }
        int len = images.size();
        int[][] ImageArrays = new int[len][];
        for (int i = 0; i < len; ++i) {
            int width = ((BufferedImage)images.get(i)).getWidth();
            int height = ((BufferedImage)images.get(i)).getHeight();
            ImageArrays[i] = new int[width * height];
            ImageArrays[i] = ((BufferedImage)images.get(i)).getRGB(0, 0, width, height, ImageArrays[i], 0, width);
            dstWidth = dstWidth > width ? dstWidth : width;
            dstHeight += height;
        }
        if (dstHeight < 1) {
            System.out.println("dstHeight < 1");
            return "";
        }
        try {
            BufferedImage imageNew = new BufferedImage(dstWidth, dstHeight, 1);
            int height_i = 0;
            for (int i = 0; i < images.size(); ++i) {
                int width = ((BufferedImage)images.get(i)).getWidth();
                int height = ((BufferedImage)images.get(i)).getHeight();
                imageNew.setRGB(0, height_i, width, height, ImageArrays[i], 0, width);
                height_i += height;
            }
            resImage = EISFileUtils.bufferedImageToBase64(imageNew);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resImage;
    }

    private static String bufferedImageToBase64(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", stream);
        String base64 = Base64.getEncoder().encodeToString(stream.toByteArray());
        return base64;
    }
}

