/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.Buyer;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.DetailInformationOfAirTicketTuple;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.EInvoice;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.GoodsInfo;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.GoodsInfos;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISModel.Seller;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.XBRLType;
import com.inspur.gs.xbrl.tools.webapi.EISFolder.XmlFullInvoiceExtractor;
import com.pansoft.xbrl.xbrljson.convert.XbrlToJson;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class EISCommonService {
    public static EInvoice formatEInvoice(String xbrlXml, InputStream inputStream, XBRLType xbrlType) throws Exception {
        EInvoice eInvoice = new EInvoice();
        if (xbrlType == XBRLType.atr_issuer) {
            eInvoice = EISCommonService.formatAtr(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.inv_ord_issuer) {
            eInvoice = EISCommonService.formatInv_ord_spcl_tlf(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.inv_spcl_issuer) {
            eInvoice = EISCommonService.formatInv_ord_spcl_tlf(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.inv_tlf_issuer) {
            eInvoice = EISCommonService.formatInv_ord_spcl_tlf(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.ntrev_gpm_issuer) {
            eInvoice = EISCommonService.formatNtrev_gpm(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.rai_issuer) {
            eInvoice = EISCommonService.formatRai(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.bker_issuer) {
            eInvoice = EISCommonService.formatBker(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.bkrs) {
            eInvoice = EISCommonService.formatBkrs(xbrlXml, xbrlType);
        } else if (xbrlType == XBRLType.czdzpj) {
            eInvoice = EISCommonService.formatCzdzpj(inputStream, xbrlType);
        } else if (xbrlType == XBRLType.FullElectricInvoice) {
            eInvoice = EISCommonService.formatFullElectricInvoice(inputStream, xbrlType);
        } else if (xbrlType == XBRLType.FullElectricInvoiceSpecial) {
            eInvoice = EISCommonService.formatFullElectricInvoiceSpecial(inputStream, xbrlType);
        }
        if (eInvoice.InvoiceDate == null || eInvoice.InvoiceDate == "") {
            eInvoice.InvoiceDate = eInvoice.IssueDate;
        }
        eInvoice.GraphCode = "10009," + eInvoice.TypeCode;
        return eInvoice;
    }

    private static EInvoice formatInv_ord_spcl_tlf(String xbrlXml, XBRLType xbrlType) throws Exception {
        EInvoice eInvoice = new EInvoice();
        XbrlToJson xbrlToJson = new XbrlToJson();
        JSONObject jsonObject = xbrlToJson.convertXbrlJsonData(xbrlXml, xbrlType.toString());
        System.out.println(jsonObject);
        if (jsonObject != null) {
            String inTypeValue;
            eInvoice.InvoiceCat = "FP";
            String string = inTypeValue = jsonObject.get((Object)"TypeOfInvoice") == null ? "" : jsonObject.get((Object)"TypeOfInvoice").toString();
            if (inTypeValue.contains("\u666e\u901a\u53d1\u7968")) {
                eInvoice.TypeCode = "1";
            }
            if (inTypeValue.contains("\u4e13\u7528\u53d1\u7968")) {
                eInvoice.TypeCode = "2";
            }
            if (inTypeValue.contains("\u7535\u5b50\u666e\u901a\u53d1\u7968")) {
                eInvoice.TypeCode = "51";
            }
            if (inTypeValue.contains("\u7535\u5b50\u4e13\u7528\u53d1\u7968")) {
                eInvoice.TypeCode = "13";
            }
            if (inTypeValue.contains("\u5377\u7968")) {
                eInvoice.TypeCode = "11";
            }
            if (eInvoice.TypeCode == null || eInvoice.TypeCode == "") {
                eInvoice.TypeCode = "55";
            }
            eInvoice.InvoiceCode = jsonObject.get((Object)"CodeOfInvoice") == null ? "" : jsonObject.get((Object)"CodeOfInvoice").toString();
            eInvoice.InvoiceNo = jsonObject.get((Object)"NumberOfInvoice") == null ? "" : jsonObject.get((Object)"NumberOfInvoice").toString();
            eInvoice.IssueDate = jsonObject.get((Object)"DateOfIssue") == null ? "" : jsonObject.get((Object)"DateOfIssue").toString();
            eInvoice.InvoiceCheckCode = jsonObject.get((Object)"IdentifyingCode") == null ? "" : jsonObject.get((Object)"IdentifyingCode").toString();
            eInvoice.MachineNo = jsonObject.get((Object)"NumberOfInvoiceMachine") == null ? "" : jsonObject.get((Object)"NumberOfInvoiceMachine").toString();
            eInvoice.TaxInclusiveTotalAmount = jsonObject.get((Object)"TaxIncludedAmountInFigures") == null ? "" : jsonObject.get((Object)"TaxIncludedAmountInFigures").toString();
            eInvoice.TaxTotalAmount = jsonObject.get((Object)"TotalTaxAmount") == null ? "" : jsonObject.get((Object)"TotalTaxAmount").toString();
            eInvoice.TaxExclusiveTotalAmount = jsonObject.get((Object)"TotalAmountExcludingTax") == null ? "" : jsonObject.get((Object)"TotalAmountExcludingTax").toString();
            eInvoice.InvoiceCode = jsonObject.get((Object)"CodeOfInvoice") == null ? "" : jsonObject.get((Object)"CodeOfInvoice").toString();
            eInvoice.InvoiceClerk = jsonObject.get((Object)"Issuer") == null ? "" : jsonObject.get((Object)"Issuer").toString();
            eInvoice.Payee = jsonObject.get((Object)"Payee") == null ? "" : jsonObject.get((Object)"Payee").toString();
            eInvoice.Checker = jsonObject.get((Object)"Reviewer") == null ? "" : jsonObject.get((Object)"Reviewer").toString();
            (eInvoice.buyer = new Buyer()).BuyerTaxID = jsonObject.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser") == null ? "" : jsonObject.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser").toString();
            eInvoice.buyer.BuyerFinancialAccount = jsonObject.get((Object)"DepositBankAndAccountNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"DepositBankAndAccountNumberOfPurchaser").toString();
            eInvoice.buyer.BuyerName = jsonObject.get((Object)"NameOfPurchaser") == null ? "" : jsonObject.get((Object)"NameOfPurchaser").toString();
            eInvoice.buyer.BuyerAddrTel = jsonObject.get((Object)"AddressPhoneNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"AddressPhoneNumberOfPurchaser").toString();
            (eInvoice.seller = new Seller()).SellerAddrTel = jsonObject.get((Object)"AddressPhoneNumberOfSeller") == null ? "" : jsonObject.get((Object)"AddressPhoneNumberOfSeller").toString();
            eInvoice.seller.SellerName = jsonObject.get((Object)"NameOfSeller") == null ? "" : jsonObject.get((Object)"NameOfSeller").toString();
            eInvoice.seller.SellerTaxID = jsonObject.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller") == null ? "" : jsonObject.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller").toString();
            eInvoice.seller.SellerFinancialAccount = jsonObject.get((Object)"DepositBankAndAccountNumberOfSeller") == null ? "" : jsonObject.get((Object)"DepositBankAndAccountNumberOfSeller").toString();
            try {
                eInvoice.goodsInfos = new GoodsInfos();
                eInvoice.goodsInfos.goodsInfos = new ArrayList<GoodsInfo>();
                JSONObject job = jsonObject.getJSONObject("InformationOfTollFeeDetailItemsTuple");
                if (job != null) {
                    GoodsInfo goodsInfo = new GoodsInfo();
                    goodsInfo.Item = job.get((Object)"NameOfTollFeeItems") == null ? "" : job.get((Object)"NameOfTollFeeItems").toString();
                    goodsInfo.PLATENO = job.get((Object)"PlateNumber") == null ? "" : job.get((Object)"PlateNumber").toString();
                    goodsInfo.PLATETYPE = job.get((Object)"TypesOfVehicle") == null ? "" : job.get((Object)"TypesOfVehicle").toString();
                    goodsInfo.TRAFFICDATESTART = job.get((Object)"EntranceDate") == null ? "" : job.get((Object)"EntranceDate").toString();
                    goodsInfo.TRAFFICDATEEND = job.get((Object)"ExitDate") == null ? "" : job.get((Object)"ExitDate").toString();
                    goodsInfo.Amount = job.get((Object)"AmountExcludingTax") == null ? "" : job.get((Object)"AmountExcludingTax").toString();
                    goodsInfo.TaxScheme = job.get((Object)"TaxRate") == null ? "" : job.get((Object)"TaxRate").toString();
                    goodsInfo.TaxAmount = job.get((Object)"TaxAmount") == null ? "" : job.get((Object)"TaxAmount").toString();
                    eInvoice.TypeCode = "14";
                    eInvoice.goodsInfos.goodsInfos.add(goodsInfo);
                } else {
                    JSONArray jobArr = jsonObject.getJSONArray("InformationOfTaxableGoodsOrServicesDetailItemsTuple");
                    for (Object object : jobArr) {
                        GoodsInfo goodsInfo = new GoodsInfo();
                        JSONObject jobj = JSONObject.parseObject((String)JSON.toJSONString(object));
                        if (jobj != null) {
                            goodsInfo.Item = jobj.get((Object)"NameOfTaxableGoodsOrServices") == null ? "" : jobj.get((Object)"NameOfTaxableGoodsOrServices").toString();
                            goodsInfo.MeasurementDimension = jobj.get((Object)"UnitOfGoodsOrServices") == null ? "" : jobj.get((Object)"UnitOfGoodsOrServices").toString();
                            goodsInfo.Quantity = jobj.get((Object)"QuantityOfGoodsOrServices") == null ? "" : jobj.get((Object)"QuantityOfGoodsOrServices").toString();
                            goodsInfo.Price = jobj.get((Object)"UnitPriceOfGoodsOrServices") == null ? "" : jobj.get((Object)"UnitPriceOfGoodsOrServices").toString();
                            goodsInfo.Amount = jobj.get((Object)"AmountExcludingTax") == null ? "" : jobj.get((Object)"AmountExcludingTax").toString();
                            goodsInfo.TaxScheme = jobj.get((Object)"TaxRate") == null ? "" : jobj.get((Object)"TaxRate").toString();
                            goodsInfo.TaxAmount = jobj.get((Object)"TaxAmount") == null ? "" : jobj.get((Object)"TaxAmount").toString();
                        }
                        eInvoice.goodsInfos.goodsInfos.add(goodsInfo);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return eInvoice;
    }

    private static EInvoice formatNtrev_gpm(String xbrlXml, XBRLType xbrlType) throws Exception {
        JSONArray arr;
        EInvoice eInvoice = new EInvoice();
        XbrlToJson xbrlToJson = new XbrlToJson();
        JSONObject jsonObject = xbrlToJson.convertXbrlJsonData(xbrlXml, xbrlType.toString());
        System.out.println(jsonObject);
        if (jsonObject != null && (arr = (JSONArray)jsonObject.get((Object)"EINVOICE_DATA")).size() > 0) {
            JSONArray DETAILS_arr;
            JSONObject EINVOICE_DATA_Obj = arr.getJSONObject(0);
            JSONArray MAIN_arr = (JSONArray)EINVOICE_DATA_Obj.get((Object)"MAIN");
            if (MAIN_arr.size() > 0) {
                JSONArray PAYER_PARTY_arr;
                System.out.println("1");
                JSONObject MAIN_Obj = MAIN_arr.getJSONObject(0);
                eInvoice.InvoiceCat = "QT";
                eInvoice.TypeCode = "55";
                eInvoice.InvoiceCode = MAIN_Obj.get((Object)"EINVOICE_CODE") == null ? "" : MAIN_Obj.get((Object)"EINVOICE_CODE").toString();
                eInvoice.InvoiceNo = MAIN_Obj.get((Object)"NON_TAX_PAY_NO") == null ? "" : MAIN_Obj.get((Object)"NON_TAX_PAY_NO").toString();
                eInvoice.IssueDate = MAIN_Obj.get((Object)"BILL_DATE") == null ? "" : MAIN_Obj.get((Object)"BILL_DATE").toString();
                eInvoice.InvoiceCheckCode = MAIN_Obj.get((Object)"RANDOM_NUMBER") == null ? "" : MAIN_Obj.get((Object)"RANDOM_NUMBER").toString();
                eInvoice.TaxInclusiveTotalAmount = MAIN_Obj.get((Object)"PAID_AMT") == null ? "" : MAIN_Obj.get((Object)"PAID_AMT").toString();
                eInvoice.InvoiceClerk = MAIN_Obj.get((Object)"AUTHOR") == null ? "" : MAIN_Obj.get((Object)"AUTHOR").toString();
                eInvoice.Checker = MAIN_Obj.get((Object)"CHECKER") == null ? "" : MAIN_Obj.get((Object)"CHECKER").toString();
                JSONArray EXEC_AGENCY_PARTY_arr = MAIN_Obj.getJSONArray("EXEC_AGENCY_PARTY");
                if (EXEC_AGENCY_PARTY_arr.size() > 0) {
                    JSONObject EXEC_AGENCY_PARTY_obj = EXEC_AGENCY_PARTY_arr.getJSONObject(0);
                    (eInvoice.seller = new Seller()).SellerName = EXEC_AGENCY_PARTY_obj.get((Object)"PAYEE_ACCT_NAME") == null ? "" : EXEC_AGENCY_PARTY_obj.get((Object)"PAYEE_ACCT_NAME").toString();
                    eInvoice.seller.SellerTaxID = EXEC_AGENCY_PARTY_obj.get((Object)"PAYEE_ACCT_NO") == null ? "" : EXEC_AGENCY_PARTY_obj.get((Object)"PAYEE_ACCT_NO").toString();
                    String string = eInvoice.seller.SellerFinancialAccount = EXEC_AGENCY_PARTY_obj.get((Object)"PAYEE_ACCT_BANK_NAME") == null ? "" : EXEC_AGENCY_PARTY_obj.get((Object)"PAYEE_ACCT_BANK_NAME").toString();
                }
                if ((PAYER_PARTY_arr = MAIN_Obj.getJSONArray("PAYER_PARTY")).size() > 0) {
                    JSONObject PAYER_PARTY_obj = PAYER_PARTY_arr.getJSONObject(0);
                    (eInvoice.buyer = new Buyer()).BuyerTaxID = PAYER_PARTY_obj.get((Object)"PAYER_ACC_NO") == null ? "" : PAYER_PARTY_obj.get((Object)"PAYER_ACC_NO").toString();
                    eInvoice.buyer.BuyerFinancialAccount = PAYER_PARTY_obj.get((Object)"PAYER_OPEN_BANK") == null ? "" : PAYER_PARTY_obj.get((Object)"PAYER_OPEN_BANK").toString();
                    String string = eInvoice.buyer.BuyerName = PAYER_PARTY_obj.get((Object)"PAYER_NAME") == null ? "" : PAYER_PARTY_obj.get((Object)"PAYER_NAME").toString();
                }
            }
            if ((DETAILS_arr = (JSONArray)EINVOICE_DATA_Obj.get((Object)"DETAILS")).size() > 0) {
                eInvoice.goodsInfos = new GoodsInfos();
                eInvoice.goodsInfos.goodsInfos = new ArrayList<GoodsInfo>();
                JSONObject ITEM_obj = DETAILS_arr.getJSONObject(0);
                JSONArray ITEM_arr = ITEM_obj.getJSONArray("ITEM");
                for (Object obj : ITEM_arr) {
                    JSONObject jobject = JSONObject.parseObject((String)JSON.toJSONString(obj));
                    GoodsInfo goodsInfo = new GoodsInfo();
                    goodsInfo.Item = jobject.getString("NON_TAX_NAME");
                    goodsInfo.Quantity = jobject.getString("PAY_NUMBER");
                    goodsInfo.MeasurementDimension = jobject.getString("CHARGE_STAND_UNIT");
                    goodsInfo.Price = jobject.getString("CHARGE_STAND");
                    goodsInfo.Amount = jobject.getString("PAID_DETAIL_AMT");
                    eInvoice.goodsInfos.goodsInfos.add(goodsInfo);
                }
            }
        }
        return eInvoice;
    }

    private static EInvoice formatRai(String xbrlXml, XBRLType xbrlType) throws Exception {
        EInvoice eInvoice = new EInvoice();
        XbrlToJson xbrlToJson = new XbrlToJson();
        JSONObject jsonObject = xbrlToJson.convertXbrlJsonData(xbrlXml, xbrlType.toString());
        System.out.println(jsonObject);
        if (jsonObject != null) {
            Date date;
            eInvoice.InvoiceCat = "CC";
            eInvoice.TypeCode = "32";
            eInvoice.InvoiceCode = jsonObject.get((Object)"ETicketNumber") == null ? "" : jsonObject.get((Object)"ETicketNumber").toString();
            eInvoice.InvoiceNo = jsonObject.get((Object)"ElectronicInvoiceRailwayETicketNumber") == null ? "" : jsonObject.get((Object)"ElectronicInvoiceRailwayETicketNumber").toString();
            String datestr = jsonObject.get((Object)"TravelDate") == null ? "" : jsonObject.get((Object)"TravelDate").toString();
            String timestr = jsonObject.get((Object)"DepartureTime") == null ? "" : jsonObject.get((Object)"DepartureTime").toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DateFormat df7 = DateFormat.getTimeInstance(2, Locale.CHINA);
            String timeNow = df7.format(new Date());
            if (datestr != null && datestr != "") {
                datestr = datestr.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "").replace("/", "-");
            } else {
                SimpleDateFormat sdft = new SimpleDateFormat("yyyy-MM-dd");
                datestr = sdft.format(new Date());
            }
            try {
                if (timestr == null || timestr == "") {
                    timestr = timeNow;
                } else if (timestr.length() == 5) {
                    timestr = timestr + ":00";
                }
                date = sdf.parse(datestr + " " + timestr);
            }
            catch (ParseException e) {
                date = sdf.parse(datestr + " " + timeNow);
            }
            eInvoice.IssueDate = sdate.format(date);
            eInvoice.InvoiceDate = jsonObject.get((Object)"DateOfIssue") == null ? "" : jsonObject.get((Object)"DateOfIssue").toString();
            eInvoice.DepartureStation = jsonObject.get((Object)"DepartureStation") == null ? "" : jsonObject.get((Object)"DepartureStation").toString();
            eInvoice.DestinationStation = jsonObject.get((Object)"DestinationStation") == null ? "" : jsonObject.get((Object)"DestinationStation").toString();
            eInvoice.TrainNumber = jsonObject.get((Object)"TrainNumber") == null ? "" : jsonObject.get((Object)"TrainNumber").toString();
            eInvoice.IdNumber = jsonObject.get((Object)"IdNumber") == null ? "" : jsonObject.get((Object)"IdNumber").toString();
            eInvoice.IdName = jsonObject.get((Object)"Name") == null ? "" : jsonObject.get((Object)"Name").toString();
            String AirConditioningCharacteristics = jsonObject.get((Object)"AirConditioningCharacteristics") == null ? "" : jsonObject.get((Object)"AirConditioningCharacteristics").toString();
            String SeatLevel = jsonObject.get((Object)"SeatLevel") == null ? "" : jsonObject.get((Object)"SeatLevel").toString();
            eInvoice.SeatLevel = AirConditioningCharacteristics + SeatLevel;
            eInvoice.TaxInclusiveTotalAmount = jsonObject.get((Object)"Fare") == null ? "" : jsonObject.get((Object)"Fare").toString();
            eInvoice.TaxTotalAmount = jsonObject.get((Object)"TaxAmount") == null ? "" : jsonObject.get((Object)"TaxAmount").toString();
            eInvoice.TaxExclusiveTotalAmount = jsonObject.get((Object)"TotalAmountExcludingTax") == null ? "" : jsonObject.get((Object)"TotalAmountExcludingTax").toString();
            eInvoice.VatRate = jsonObject.get((Object)"TaxRate") == null ? "" : jsonObject.get((Object)"TaxRate").toString();
            (eInvoice.buyer = new Buyer()).BuyerTaxID = jsonObject.get((Object)"UnifiedSocialCreditCodeOfPurchaser") == null ? "" : jsonObject.get((Object)"UnifiedSocialCreditCodeOfPurchaser").toString();
            eInvoice.buyer.BuyerFinancialAccount = jsonObject.get((Object)"DepositBankAndAccountNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"DepositBankAndAccountNumberOfPurchaser").toString();
            eInvoice.buyer.BuyerName = jsonObject.get((Object)"NameOfPurchaser") == null ? "" : jsonObject.get((Object)"NameOfPurchaser").toString();
            eInvoice.buyer.BuyerAddrTel = jsonObject.get((Object)"AddressPhoneNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"AddressPhoneNumberOfPurchaser").toString();
            (eInvoice.seller = new Seller()).SellerAddrTel = jsonObject.get((Object)"AddressPhoneNumberOfSeller") == null ? "" : jsonObject.get((Object)"AddressPhoneNumberOfSeller").toString();
            eInvoice.seller.SellerName = jsonObject.get((Object)"NameOfSeller") == null ? "" : jsonObject.get((Object)"NameOfSeller").toString();
            eInvoice.seller.SellerTaxID = jsonObject.get((Object)"UnifiedSocialCreditCodeOfSeller") == null ? "" : jsonObject.get((Object)"UnifiedSocialCreditCodeOfSeller").toString();
            eInvoice.seller.SellerFinancialAccount = jsonObject.get((Object)"DepositBankAndAccountNumberOfSeller") == null ? "" : jsonObject.get((Object)"DepositBankAndAccountNumberOfSeller").toString();
        }
        return eInvoice;
    }

    private static EInvoice formatBker(String xbrlXml, XBRLType xbrlType) throws Exception {
        EInvoice eInvoice = new EInvoice();
        XbrlToJson xbrlToJson = new XbrlToJson();
        JSONObject jsonObject = xbrlToJson.convertXbrlJsonData(xbrlXml, xbrlType.toString());
        System.out.println(jsonObject);
        if (jsonObject != null) {
            String CreditOrDebit;
            eInvoice.InvoiceCat = "DZPZ";
            eInvoice.TypeCode = "YHHD";
            eInvoice.InvoiceNo = jsonObject.get((Object)"NumberOfBankElectronicReceipt") == null ? "" : jsonObject.get((Object)"NumberOfBankElectronicReceipt").toString();
            eInvoice.InvoiceCode = jsonObject.get((Object)"IdentificationCodeOfIssuer") == null ? "" : jsonObject.get((Object)"IdentificationCodeOfIssuer").toString();
            eInvoice.IssueDate = jsonObject.get((Object)"IssueDate") == null ? "" : jsonObject.get((Object)"IssueDate").toString();
            eInvoice.DateOfBookkeeping = jsonObject.get((Object)"DateOfBookkeeping") == null ? "" : jsonObject.get((Object)"DateOfBookkeeping").toString();
            eInvoice.MachineNo = jsonObject.get((Object)"IdentifyingCode") == null ? "" : jsonObject.get((Object)"IdentifyingCode").toString();
            eInvoice.TransactionCode = Optional.ofNullable(jsonObject.get((Object)"TransactionCode")).map(Object::toString).orElse("");
            eInvoice.Currency = Optional.ofNullable(jsonObject.get((Object)"Currency")).map(Object::toString).orElse("");
            eInvoice.TaxInclusiveTotalAmount = jsonObject.get((Object)"TransactionAmountInFigures") == null ? "" : jsonObject.get((Object)"TransactionAmountInFigures").toString();
            eInvoice.IdentificationOfCreditOrDebit = Optional.ofNullable(jsonObject.get((Object)"IdentificationOfCreditOrDebit")).map(Object::toString).orElse("");
            eInvoice.Note = Optional.ofNullable(jsonObject.get((Object)"Usage")).map(Object::toString).orElse("");
            String string = CreditOrDebit = jsonObject.get((Object)"IdentificationOfCreditOrDebit") == null ? "" : jsonObject.get((Object)"IdentificationOfCreditOrDebit").toString();
            if ("0".equals(CreditOrDebit)) {
                (eInvoice.buyer = new Buyer()).BuyerName = jsonObject.get((Object)"AccountNameOfPayee") == null ? "" : jsonObject.get((Object)"AccountNameOfPayee").toString();
                eInvoice.buyer.BuyerTaxID = jsonObject.get((Object)"AccountNumberOfPayee") == null ? "" : jsonObject.get((Object)"AccountNumberOfPayee").toString();
                eInvoice.buyer.BuyerFinancialAccount = jsonObject.get((Object)"OpeningBankOfPayee") == null ? "" : jsonObject.get((Object)"OpeningBankOfPayee").toString();
                (eInvoice.seller = new Seller()).SellerName = jsonObject.get((Object)"AccountNameOfPayer") == null ? "" : jsonObject.get((Object)"AccountNameOfPayer").toString();
                eInvoice.seller.SellerTaxID = jsonObject.get((Object)"AccountNumberOfPayer") == null ? "" : jsonObject.get((Object)"AccountNumberOfPayer").toString();
                eInvoice.seller.SellerFinancialAccount = jsonObject.get((Object)"OpeningBankOfPayer") == null ? "" : jsonObject.get((Object)"OpeningBankOfPayer").toString();
            } else {
                (eInvoice.buyer = new Buyer()).BuyerName = jsonObject.get((Object)"AccountNameOfPayer") == null ? "" : jsonObject.get((Object)"AccountNameOfPayer").toString();
                eInvoice.buyer.BuyerTaxID = jsonObject.get((Object)"AccountNumberOfPayer") == null ? "" : jsonObject.get((Object)"AccountNumberOfPayer").toString();
                eInvoice.buyer.BuyerFinancialAccount = jsonObject.get((Object)"OpeningBankOfPayer") == null ? "" : jsonObject.get((Object)"OpeningBankOfPayer").toString();
                (eInvoice.seller = new Seller()).SellerName = jsonObject.get((Object)"AccountNameOfPayee") == null ? "" : jsonObject.get((Object)"AccountNameOfPayee").toString();
                eInvoice.seller.SellerTaxID = jsonObject.get((Object)"AccountNumberOfPayee") == null ? "" : jsonObject.get((Object)"AccountNumberOfPayee").toString();
                eInvoice.seller.SellerFinancialAccount = jsonObject.get((Object)"OpeningBankOfPayee") == null ? "" : jsonObject.get((Object)"OpeningBankOfPayee").toString();
            }
        }
        return eInvoice;
    }

    private static EInvoice formatAtr(String xbrlXml, XBRLType xbrlType) throws Exception {
        EInvoice eInvoice = new EInvoice();
        XbrlToJson xbrlToJson = new XbrlToJson();
        JSONObject jsonObject = xbrlToJson.convertXbrlJsonData(xbrlXml, xbrlType.toString());
        System.out.println(jsonObject);
        if (jsonObject != null) {
            eInvoice.InvoiceCat = "CC";
            eInvoice.TypeCode = "33";
            eInvoice.InvoiceCode = jsonObject.get((Object)"ElectronicInvoiceAirTransportReceiptNumber") == null ? "" : jsonObject.get((Object)"ElectronicInvoiceAirTransportReceiptNumber").toString();
            eInvoice.InvoiceNo = jsonObject.get((Object)"ETicketNumber") == null ? "" : jsonObject.get((Object)"ETicketNumber").toString();
            eInvoice.InvoiceDate = jsonObject.get((Object)"IssueDate") == null ? "" : jsonObject.get((Object)"IssueDate").toString();
            eInvoice.InvoiceCheckCode = jsonObject.get((Object)"VerificationCode") == null ? "" : jsonObject.get((Object)"VerificationCode").toString();
            eInvoice.Note = jsonObject.get((Object)"Endorsement") == null ? "" : jsonObject.get((Object)"Endorsement").toString();
            eInvoice.InvoiceClerk = jsonObject.get((Object)"Issuer") == null ? "" : jsonObject.get((Object)"Issuer").toString();
            eInvoice.Checker = jsonObject.get((Object)"Reviewer") == null ? "" : jsonObject.get((Object)"Reviewer").toString();
            eInvoice.TaxInclusiveTotalAmount = jsonObject.get((Object)"TotalAmount") == null ? "" : jsonObject.get((Object)"TotalAmount").toString();
            eInvoice.TaxTotalAmount = jsonObject.get((Object)"VatTaxAmount") == null ? "" : jsonObject.get((Object)"VatTaxAmount").toString();
            eInvoice.TaxExclusiveTotalAmount = jsonObject.get((Object)"Fare") == null ? "" : jsonObject.get((Object)"Fare").toString();
            eInvoice.VatRate = jsonObject.get((Object)"VatRate") == null ? "" : jsonObject.get((Object)"VatRate").toString();
            eInvoice.Fare = jsonObject.get((Object)"Fare") == null ? "" : jsonObject.get((Object)"Fare").toString();
            eInvoice.FuelSurcharge = jsonObject.get((Object)"FuelSurcharge") == null ? "" : jsonObject.get((Object)"FuelSurcharge").toString();
            eInvoice.VatTaxAmount = jsonObject.get((Object)"VatTaxAmount") == null ? "" : jsonObject.get((Object)"VatTaxAmount").toString();
            eInvoice.CivilAviationDevelopmentFund = jsonObject.get((Object)"CivilAviationDevelopmentFund") == null ? "" : jsonObject.get((Object)"CivilAviationDevelopmentFund").toString();
            eInvoice.OtherTaxes = jsonObject.get((Object)"OtherTaxes") == null ? "" : jsonObject.get((Object)"OtherTaxes").toString();
            eInvoice.Insurance = jsonObject.get((Object)"Insurance") == null ? "" : jsonObject.get((Object)"Insurance").toString();
            eInvoice.MachineNo = jsonObject.get((Object)"NumberOfGpOrder") == null ? "" : jsonObject.get((Object)"NumberOfGpOrder").toString();
            eInvoice.IdName = jsonObject.get((Object)"PassengerName") == null ? "" : jsonObject.get((Object)"PassengerName").toString();
            eInvoice.IdNumber = jsonObject.get((Object)"ValidIdNumber") == null ? "" : jsonObject.get((Object)"ValidIdNumber").toString();
            (eInvoice.buyer = new Buyer()).BuyerName = jsonObject.get((Object)"NameOfPurchaser") == null ? "" : jsonObject.get((Object)"NameOfPurchaser").toString();
            eInvoice.buyer.BuyerTaxID = jsonObject.get((Object)"TaxpayerIdentificationNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"TaxpayerIdentificationNumberOfPurchaser").toString();
            eInvoice.buyer.BuyerAddrTel = jsonObject.get((Object)"AddressPhoneNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"AddressPhoneNumberOfPurchaser").toString();
            eInvoice.buyer.BuyerFinancialAccount = jsonObject.get((Object)"DepositBankAndAccountNumberOfPurchaser") == null ? "" : jsonObject.get((Object)"DepositBankAndAccountNumberOfPurchaser").toString();
            eInvoice.detailInformationOfAirTicketTuples = new ArrayList<DetailInformationOfAirTicketTuple>();
            String airTicketTupleStr = jsonObject.getString("DetailInformationOfAirTicketTuple");
            if (airTicketTupleStr != null && airTicketTupleStr != "") {
                List airTicketTuples = JSON.parseArray((String)airTicketTupleStr, JSONObject.class);
                for (JSONObject job : airTicketTuples) {
                    Date date;
                    DetailInformationOfAirTicketTuple detailInformationOfAirTicketTuple = new DetailInformationOfAirTicketTuple();
                    String datestr = job.getString("CarrierDate");
                    String timestr = job.getString("DepartureTime");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat sdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    DateFormat df7 = DateFormat.getTimeInstance(2, Locale.CHINA);
                    String timeNow = df7.format(new Date());
                    if (datestr != null && datestr != "") {
                        datestr = datestr.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "").replace("/", "-");
                    } else {
                        SimpleDateFormat sdft = new SimpleDateFormat("yyyy-MM-dd");
                        datestr = sdft.format(new Date());
                    }
                    try {
                        if (timestr == null || timestr == "") {
                            timestr = timeNow;
                        } else if (timestr.length() == 5) {
                            timestr = timestr + ":00";
                        }
                        date = sdf.parse(datestr + " " + timestr);
                    }
                    catch (ParseException e) {
                        date = sdf.parse(datestr + " " + timeNow);
                    }
                    detailInformationOfAirTicketTuple.CarrierDate = sdate.format(date);
                    detailInformationOfAirTicketTuple.DepartureTime = timestr;
                    if (eInvoice.IssueDate == null || eInvoice.IssueDate == "") {
                        eInvoice.IssueDate = detailInformationOfAirTicketTuple.CarrierDate;
                    }
                    detailInformationOfAirTicketTuple.DepartureStation = job.getString("DepartureStation");
                    detailInformationOfAirTicketTuple.DestinationStation = job.getString("DestinationStation");
                    detailInformationOfAirTicketTuple.FlightSegment = job.getString("FlightSegment");
                    detailInformationOfAirTicketTuple.Carrier = job.getString("Carrier");
                    detailInformationOfAirTicketTuple.Flight = job.getString("Flight");
                    detailInformationOfAirTicketTuple.Class = job.getString("Class");
                    detailInformationOfAirTicketTuple.FareBasis = job.getString("FareBasis");
                    detailInformationOfAirTicketTuple.EffectiveDate = job.getString("EffectiveDate");
                    detailInformationOfAirTicketTuple.ExpirationDate = job.getString("ExpirationDate");
                    detailInformationOfAirTicketTuple.FreeBaggageAllowance = job.getString("FreeBaggageAllowance");
                    eInvoice.detailInformationOfAirTicketTuples.add(detailInformationOfAirTicketTuple);
                }
            }
        }
        return eInvoice;
    }

    private static EInvoice formatBkrs(String xbrlXml, XBRLType xbrlType) throws Exception {
        EInvoice eInvoice = new EInvoice();
        XbrlToJson xbrlToJson = new XbrlToJson();
        JSONObject jsonObject = xbrlToJson.convertXbrlJsonData(xbrlXml, xbrlType.toString());
        eInvoice.DocID = JSONObject.toJSONString((Object)jsonObject);
        System.out.println(jsonObject);
        if (jsonObject != null) {
            eInvoice.InvoiceCat = "DZPZ";
            eInvoice.TypeCode = "YHDZD";
            eInvoice.InvoiceNo = jsonObject.get((Object)"CustomerSettlementBankAccount") == null ? "" : jsonObject.get((Object)"CustomerSettlementBankAccount").toString();
            eInvoice.InvoiceCode = jsonObject.get((Object)"IdentificationCodeOfIssuer") == null ? "" : jsonObject.get((Object)"IdentificationCodeOfIssuer").toString();
            eInvoice.IssueDate = jsonObject.get((Object)"PrintDate") == null ? "" : jsonObject.get((Object)"PrintDate").toString();
            eInvoice.Currency = Optional.ofNullable(jsonObject.get((Object)"Currency")).map(Object::toString).orElse("");
            (eInvoice.buyer = new Buyer()).BuyerName = jsonObject.get((Object)"NameOfCustomerAccount") == null ? "" : jsonObject.get((Object)"NameOfCustomerAccount").toString();
            eInvoice.buyer.BuyerTaxID = jsonObject.get((Object)"CustomerSettlementBankAccount") == null ? "" : jsonObject.get((Object)"CustomerSettlementBankAccount").toString();
            eInvoice.buyer.BuyerFinancialAccount = jsonObject.get((Object)"NumberOfBankBranch") == null ? "" : jsonObject.get((Object)"NumberOfBankBranch").toString();
        }
        return eInvoice;
    }

    private static EInvoice formatCzdzpj(InputStream xml, XBRLType xbrlType) throws Exception {
        XmlFullInvoiceExtractor xmlFullInvoiceExtractor = new XmlFullInvoiceExtractor();
        EInvoice eInvoice = xmlFullInvoiceExtractor.extractCzdzpj(xml);
        eInvoice.InvoiceCat = "DZPZ";
        return eInvoice;
    }

    private static EInvoice formatFullElectricInvoiceSpecial(InputStream inputStream, XBRLType xbrlType) throws Exception {
        XmlFullInvoiceExtractor xmlFullInvoiceExtractor = new XmlFullInvoiceExtractor();
        EInvoice eInvoice = xmlFullInvoiceExtractor.extract(inputStream);
        eInvoice.InvoiceCat = "DZPZ";
        return eInvoice;
    }

    private static EInvoice formatFullElectricInvoice(InputStream inputStream, XBRLType xbrlType) throws Exception {
        XmlFullInvoiceExtractor xmlFullInvoiceExtractor = new XmlFullInvoiceExtractor();
        EInvoice eInvoice = xmlFullInvoiceExtractor.extract(inputStream);
        eInvoice.InvoiceCat = "DZPZ";
        return eInvoice;
    }
}

