/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.pqc.crypto.lms;

import java.security.SecureRandom;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPair;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastleDJ.crypto.KeyGenerationParameters;
import org.bouncycastleDJ.pqc.crypto.lms.LMS;
import org.bouncycastleDJ.pqc.crypto.lms.LMSKeyGenerationParameters;
import org.bouncycastleDJ.pqc.crypto.lms.LMSPrivateKeyParameters;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (LMSKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom secureRandom = this.param.getRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, byArray, byArray2);
        return new AsymmetricCipherKeyPair(lMSPrivateKeyParameters.getPublicKey(), lMSPrivateKeyParameters);
    }
}

