/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastleDJ.asn1.ASN1ObjectIdentifier;
import org.bouncycastleDJ.asn1.DERNull;
import org.bouncycastleDJ.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.jcajce.PKCS12Key;
import org.bouncycastleDJ.jcajce.io.MacOutputStream;
import org.bouncycastleDJ.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastleDJ.jcajce.util.JcaJceHelper;
import org.bouncycastleDJ.jcajce.util.NamedJcaJceHelper;
import org.bouncycastleDJ.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastleDJ.operator.GenericKey;
import org.bouncycastleDJ.operator.MacCalculator;
import org.bouncycastleDJ.operator.OperatorCreationException;
import org.bouncycastleDJ.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastleDJ.pkcs.PKCS12MacCalculatorBuilderProvider;

public class JcePKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePKCS12MacCalculatorBuilderProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilderProvider setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                final PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                try {
                    final ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                    final Mac mac = JcePKCS12MacCalculatorBuilderProvider.this.helper.createMac(aSN1ObjectIdentifier.getId());
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                    final PKCS12Key pKCS12Key = new PKCS12Key(cArray);
                    mac.init(pKCS12Key, pBEParameterSpec);
                    return new MacCalculator(){

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return new AlgorithmIdentifier(aSN1ObjectIdentifier, pKCS12PBEParams);
                        }

                        public OutputStream getOutputStream() {
                            return new MacOutputStream(mac);
                        }

                        public byte[] getMac() {
                            return mac.doFinal();
                        }

                        public GenericKey getKey() {
                            return new GenericKey(this.getAlgorithmIdentifier(), pKCS12Key.getEncoded());
                        }
                    };
                }
                catch (Exception exception) {
                    throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
                }
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

