/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.pkcs.bc;

import org.bouncycastleDJ.asn1.DERNull;
import org.bouncycastleDJ.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.operator.MacCalculator;
import org.bouncycastleDJ.operator.OperatorCreationException;
import org.bouncycastleDJ.operator.bc.BcDigestProvider;
import org.bouncycastleDJ.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastleDJ.pkcs.PKCS12MacCalculatorBuilderProvider;
import org.bouncycastleDJ.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider bcDigestProvider) {
        this.digestProvider = bcDigestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pKCS12PBEParams, cArray);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

