/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.pkcs;

import org.bouncycastleDJ.asn1.ASN1OctetString;
import org.bouncycastleDJ.asn1.ASN1Sequence;
import org.bouncycastleDJ.asn1.cms.ContentInfo;
import org.bouncycastleDJ.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastleDJ.asn1.pkcs.SafeBag;
import org.bouncycastleDJ.cms.CMSEncryptedData;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.operator.InputDecryptorProvider;
import org.bouncycastleDJ.pkcs.PKCS12SafeBag;
import org.bouncycastleDJ.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(org.bouncycastleDJ.asn1.pkcs.ContentInfo contentInfo) {
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(org.bouncycastleDJ.asn1.pkcs.ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData cMSEncryptedData = new CMSEncryptedData(ContentInfo.getInstance(contentInfo));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(cMSEncryptedData.getContent(inputDecryptorProvider));
            }
            catch (CMSException cMSException) {
                throw new PKCSException("unable to extract data: " + cMSException.getMessage(), cMSException);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] pKCS12SafeBagArray = new PKCS12SafeBag[this.safeBagSeq.size()];
        for (int i = 0; i != this.safeBagSeq.size(); ++i) {
            pKCS12SafeBagArray[i] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i)));
        }
        return pKCS12SafeBagArray;
    }
}

