/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.operator.bc;

import java.io.IOException;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastleDJ.crypto.ExtendedDigest;
import org.bouncycastleDJ.crypto.Signer;
import org.bouncycastleDJ.crypto.params.AsymmetricKeyParameter;
import org.bouncycastleDJ.crypto.signers.RSADigestSigner;
import org.bouncycastleDJ.crypto.util.PublicKeyFactory;
import org.bouncycastleDJ.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastleDJ.operator.OperatorCreationException;
import org.bouncycastleDJ.operator.bc.BcContentVerifierProviderBuilder;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

