/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.mime.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.mime.CanonicalOutputStream;
import org.bouncycastleDJ.mime.Headers;
import org.bouncycastleDJ.mime.MimeContext;
import org.bouncycastleDJ.mime.MimeMultipartContext;
import org.bouncycastleDJ.mime.MimeParserContext;
import org.bouncycastleDJ.mime.smime.SMimeParserContext;
import org.bouncycastleDJ.mime.smime.SMimeUtils;
import org.bouncycastleDJ.operator.DigestCalculator;
import org.bouncycastleDJ.operator.OperatorCreationException;
import org.bouncycastleDJ.util.io.TeeInputStream;
import org.bouncycastleDJ.util.io.TeeOutputStream;

public class SMimeMultipartContext
implements MimeMultipartContext {
    private final SMimeParserContext parserContext;
    private DigestCalculator[] calculators;

    public SMimeMultipartContext(MimeParserContext mimeParserContext, Headers headers) {
        this.parserContext = (SMimeParserContext)mimeParserContext;
        this.calculators = this.createDigestCalculators(headers);
    }

    DigestCalculator[] getDigestCalculators() {
        return this.calculators;
    }

    OutputStream getDigestOutputStream() {
        if (this.calculators.length == 1) {
            return this.calculators[0].getOutputStream();
        }
        OutputStream outputStream = this.calculators[0].getOutputStream();
        for (int i = 1; i < this.calculators.length; ++i) {
            outputStream = new TeeOutputStream(this.calculators[i].getOutputStream(), outputStream);
        }
        return outputStream;
    }

    private DigestCalculator[] createDigestCalculators(Headers headers) {
        try {
            Map<String, String> map = headers.getContentTypeAttributes();
            String string = map.get("micalg");
            if (string == null) {
                throw new IllegalStateException("No micalg field on content-type header");
            }
            String[] stringArray = string.substring(string.indexOf(61) + 1).split(",");
            DigestCalculator[] digestCalculatorArray = new DigestCalculator[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = SMimeUtils.lessQuotes(stringArray[i]).trim();
                digestCalculatorArray[i] = this.parserContext.getDigestCalculatorProvider().get(new AlgorithmIdentifier(SMimeUtils.getDigestOID(string2)));
            }
            return digestCalculatorArray;
        }
        catch (OperatorCreationException operatorCreationException) {
            return null;
        }
    }

    public MimeContext createContext(final int n) throws IOException {
        return new MimeContext(){

            public InputStream applyContext(Headers headers, InputStream inputStream) throws IOException {
                if (n == 0) {
                    OutputStream outputStream = SMimeMultipartContext.this.getDigestOutputStream();
                    headers.dumpHeaders(outputStream);
                    outputStream.write(13);
                    outputStream.write(10);
                    return new TeeInputStream(inputStream, new CanonicalOutputStream(SMimeMultipartContext.this.parserContext, headers, outputStream));
                }
                return inputStream;
            }
        };
    }

    public InputStream applyContext(Headers headers, InputStream inputStream) throws IOException {
        return inputStream;
    }
}

