/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.math.ec.endo;

import java.math.BigInteger;
import org.bouncycastleDJ.math.ec.ECCurve;
import org.bouncycastleDJ.math.ec.ECPointMap;
import org.bouncycastleDJ.math.ec.ScaleYNegateXPointMap;
import org.bouncycastleDJ.math.ec.endo.EndoUtil;
import org.bouncycastleDJ.math.ec.endo.GLVEndomorphism;
import org.bouncycastleDJ.math.ec.endo.GLVTypeAParameters;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve eCCurve, GLVTypeAParameters gLVTypeAParameters) {
        this.parameters = gLVTypeAParameters;
        this.pointMap = new ScaleYNegateXPointMap(eCCurve.fromBigInteger(gLVTypeAParameters.getI()));
    }

    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }
}

