/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.jcajce.provider.symmetric;

import org.bouncycastleDJ.crypto.BlockCipher;
import org.bouncycastleDJ.crypto.CipherKeyGenerator;
import org.bouncycastleDJ.crypto.engines.RijndaelEngine;
import org.bouncycastleDJ.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastleDJ.jcajce.provider.util.AlgorithmProvider;

public final class Rijndael {
    private Rijndael() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Rijndael IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new RijndaelEngine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Rijndael", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Rijndael.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.RIJNDAEL", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.RIJNDAEL", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.RIJNDAEL", PREFIX + "$AlgParams");
        }
    }
}

