/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.jcajce.provider.symmetric;

import org.bouncycastleDJ.crypto.CipherKeyGenerator;
import org.bouncycastleDJ.crypto.engines.HC256Engine;
import org.bouncycastleDJ.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseStreamCipher;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastleDJ.jcajce.provider.util.AlgorithmProvider;

public final class HC256 {
    private HC256() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "HC256 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new HC256Engine(), 32);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("HC256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = HC256.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.HC256", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.HC256", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.HC256", PREFIX + "$AlgParams");
        }
    }
}

