/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.jcajce.provider.symmetric;

import org.bouncycastleDJ.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastleDJ.crypto.CipherKeyGenerator;
import org.bouncycastleDJ.crypto.engines.BlowfishEngine;
import org.bouncycastleDJ.crypto.macs.CMac;
import org.bouncycastleDJ.crypto.modes.CBCBlockCipher;
import org.bouncycastleDJ.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastleDJ.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastleDJ.jcajce.provider.util.AlgorithmProvider;

public final class Blowfish {
    private Blowfish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Blowfish IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new BlowfishEngine()), 64);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new BlowfishEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlowfishEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Blowfish", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Blowfish.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Mac.BLOWFISHCMAC", PREFIX + "$CMAC");
            configurableProvider.addAlgorithm("Cipher.BLOWFISH", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("KeyGenerator.BLOWFISH", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
            configurableProvider.addAlgorithm("AlgorithmParameters.BLOWFISH", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
        }
    }
}

