/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.jcajce.provider.asymmetric.edec;

import org.bouncycastleDJ.crypto.params.AsymmetricKeyParameter;
import org.bouncycastleDJ.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastleDJ.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastleDJ.crypto.params.X25519PublicKeyParameters;
import org.bouncycastleDJ.crypto.params.X448PublicKeyParameters;
import org.bouncycastleDJ.util.Fingerprint;
import org.bouncycastleDJ.util.Strings;
import org.bouncycastleDJ.util.encoders.Hex;

class Utils {
    Utils() {
    }

    static boolean isValidPrefix(byte[] byArray, byte[] byArray2) {
        if (byArray2.length < byArray.length) {
            return !Utils.isValidPrefix(byArray, byArray);
        }
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    static String keyToString(String string, String string2, AsymmetricKeyParameter asymmetricKeyParameter) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = Strings.lineSeparator();
        byte[] byArray = asymmetricKeyParameter instanceof X448PublicKeyParameters ? ((X448PublicKeyParameters)asymmetricKeyParameter).getEncoded() : (asymmetricKeyParameter instanceof Ed448PublicKeyParameters ? ((Ed448PublicKeyParameters)asymmetricKeyParameter).getEncoded() : (asymmetricKeyParameter instanceof X25519PublicKeyParameters ? ((X25519PublicKeyParameters)asymmetricKeyParameter).getEncoded() : ((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded()));
        stringBuffer.append(string2).append(" ").append(string).append(" [").append(Utils.generateKeyFingerprint(byArray)).append("]").append(string3).append("    public data: ").append(Hex.toHexString(byArray)).append(string3);
        return stringBuffer.toString();
    }

    private static String generateKeyFingerprint(byte[] byArray) {
        return new Fingerprint(byArray).toString();
    }
}

