/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.dvcs;

import org.bouncycastleDJ.asn1.dvcs.Data;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.CMSSignedData;
import org.bouncycastleDJ.dvcs.DVCSConstructionException;
import org.bouncycastleDJ.dvcs.DVCSRequestData;

public class VSDRequestData
extends DVCSRequestData {
    private CMSSignedData doc;

    VSDRequestData(Data data) throws DVCSConstructionException {
        super(data);
        this.initDocument();
    }

    private void initDocument() throws DVCSConstructionException {
        if (this.doc == null) {
            if (this.data.getMessage() == null) {
                throw new DVCSConstructionException("DVCSRequest.data.message should be specified for VSD service");
            }
            try {
                this.doc = new CMSSignedData(this.data.getMessage().getOctets());
            }
            catch (CMSException cMSException) {
                throw new DVCSConstructionException("Can't read CMS SignedData from input", cMSException);
            }
        }
    }

    public byte[] getMessage() {
        return this.data.getMessage().getOctets();
    }

    public CMSSignedData getParsedMessage() {
        return this.doc;
    }
}

