/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.dvcs;

import java.io.IOException;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.CMSProcessableByteArray;
import org.bouncycastleDJ.cms.CMSSignedData;
import org.bouncycastleDJ.cms.CMSSignedDataGenerator;
import org.bouncycastleDJ.dvcs.DVCSException;
import org.bouncycastleDJ.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

