/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.dvcs;

import java.io.OutputStream;
import org.bouncycastleDJ.asn1.x509.DigestInfo;
import org.bouncycastleDJ.dvcs.DVCSException;
import org.bouncycastleDJ.dvcs.MessageImprint;
import org.bouncycastleDJ.operator.DigestCalculator;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] byArray) throws DVCSException {
        try {
            OutputStream outputStream = this.digestCalculator.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception exception) {
            throw new DVCSException("unable to build MessageImprint: " + exception.getMessage(), exception);
        }
    }
}

