/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.signers;

import java.io.ByteArrayOutputStream;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.Signer;
import org.bouncycastleDJ.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastleDJ.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastleDJ.math.ec.rfc8032.Ed25519;
import org.bouncycastleDJ.util.Arrays;

public class Ed25519Signer
implements Signer {
    private final Buffer buffer = new Buffer();
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            this.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            this.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    public void update(byte by) {
        this.buffer.write(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
    }

    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for signature generation.");
        }
        return this.buffer.generateSignature(this.privateKey);
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for verification");
        }
        return this.buffer.verifySignature(this.publicKey, byArray);
    }

    public void reset() {
        this.buffer.reset();
    }

    private static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        synchronized byte[] generateSignature(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters) {
            byte[] byArray = new byte[64];
            ed25519PrivateKeyParameters.sign(0, null, this.buf, 0, this.count, byArray, 0);
            this.reset();
            return byArray;
        }

        synchronized boolean verifySignature(Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray) {
            if (64 != byArray.length) {
                return false;
            }
            byte[] byArray2 = ed25519PublicKeyParameters.getEncoded();
            boolean bl = Ed25519.verify(byArray, 0, byArray2, 0, this.buf, 0, this.count);
            this.reset();
            return bl;
        }

        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

