/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.params;

import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.params.AsymmetricKeyParameter;
import org.bouncycastleDJ.crypto.params.X25519PublicKeyParameters;
import org.bouncycastleDJ.crypto.params.X448PublicKeyParameters;

public class XDHUPublicParameters
implements CipherParameters {
    private AsymmetricKeyParameter staticPublicKey;
    private AsymmetricKeyParameter ephemeralPublicKey;

    public XDHUPublicParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        if (asymmetricKeyParameter == null) {
            throw new NullPointerException("staticPublicKey cannot be null");
        }
        if (!(asymmetricKeyParameter instanceof X448PublicKeyParameters) && !(asymmetricKeyParameter instanceof X25519PublicKeyParameters)) {
            throw new IllegalArgumentException("only X25519 and X448 paramaters can be used");
        }
        if (asymmetricKeyParameter2 == null) {
            throw new NullPointerException("ephemeralPublicKey cannot be null");
        }
        if (!asymmetricKeyParameter.getClass().isAssignableFrom(asymmetricKeyParameter2.getClass())) {
            throw new IllegalArgumentException("static and ephemeral public keys have different domain parameters");
        }
        this.staticPublicKey = asymmetricKeyParameter;
        this.ephemeralPublicKey = asymmetricKeyParameter2;
    }

    public AsymmetricKeyParameter getStaticPublicKey() {
        return this.staticPublicKey;
    }

    public AsymmetricKeyParameter getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

