/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.generators;

import java.math.BigInteger;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPair;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastleDJ.crypto.KeyGenerationParameters;
import org.bouncycastleDJ.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastleDJ.crypto.params.DHParameters;
import org.bouncycastleDJ.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastleDJ.crypto.params.ElGamalParameters;
import org.bouncycastleDJ.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastleDJ.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

