/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.generators;

import java.security.SecureRandom;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPair;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastleDJ.crypto.KeyGenerationParameters;
import org.bouncycastleDJ.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastleDJ.crypto.params.Ed25519PublicKeyParameters;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed25519PublicKeyParameters, ed25519PrivateKeyParameters);
    }
}

