/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPair;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastleDJ.crypto.CryptoServicesRegistrar;
import org.bouncycastleDJ.crypto.KeyGenerationParameters;
import org.bouncycastleDJ.crypto.params.ECDomainParameters;
import org.bouncycastleDJ.crypto.params.ECKeyGenerationParameters;
import org.bouncycastleDJ.crypto.params.ECPrivateKeyParameters;
import org.bouncycastleDJ.crypto.params.ECPublicKeyParameters;
import org.bouncycastleDJ.math.ec.ECConstants;
import org.bouncycastleDJ.math.ec.ECMultiplier;
import org.bouncycastleDJ.math.ec.ECPoint;
import org.bouncycastleDJ.math.ec.FixedPointCombMultiplier;
import org.bouncycastleDJ.math.ec.WNafUtil;
import org.bouncycastleDJ.util.BigIntegers;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

