/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.generators;

import java.math.BigInteger;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPair;
import org.bouncycastleDJ.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastleDJ.crypto.KeyGenerationParameters;
import org.bouncycastleDJ.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastleDJ.crypto.params.DHKeyGenerationParameters;
import org.bouncycastleDJ.crypto.params.DHParameters;
import org.bouncycastleDJ.crypto.params.DHPrivateKeyParameters;
import org.bouncycastleDJ.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

