/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.CryptoServicesRegistrar;
import org.bouncycastleDJ.crypto.ec.ECPair;
import org.bouncycastleDJ.crypto.ec.ECPairTransform;
import org.bouncycastleDJ.crypto.ec.ECUtil;
import org.bouncycastleDJ.crypto.params.ECDomainParameters;
import org.bouncycastleDJ.crypto.params.ECPublicKeyParameters;
import org.bouncycastleDJ.crypto.params.ParametersWithRandom;
import org.bouncycastleDJ.math.ec.ECAlgorithms;
import org.bouncycastleDJ.math.ec.ECMultiplier;
import org.bouncycastleDJ.math.ec.ECPoint;
import org.bouncycastleDJ.math.ec.FixedPointCombMultiplier;

public class ECNewPublicKeyTransform
implements ECPairTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewPublicKeyTransform not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        BigInteger bigInteger2 = ECUtil.generateK(bigInteger, this.random);
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2), this.key.getQ().multiply(bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getY()))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

