/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.CryptoServicesRegistrar;
import org.bouncycastleDJ.crypto.ec.ECEncryptor;
import org.bouncycastleDJ.crypto.ec.ECPair;
import org.bouncycastleDJ.crypto.ec.ECUtil;
import org.bouncycastleDJ.crypto.params.ECDomainParameters;
import org.bouncycastleDJ.crypto.params.ECPublicKeyParameters;
import org.bouncycastleDJ.crypto.params.ParametersWithRandom;
import org.bouncycastleDJ.math.ec.ECAlgorithms;
import org.bouncycastleDJ.math.ec.ECMultiplier;
import org.bouncycastleDJ.math.ec.ECPoint;
import org.bouncycastleDJ.math.ec.FixedPointCombMultiplier;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public ECPair encrypt(ECPoint eCPoint) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalEncryptor not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = ECUtil.generateK(eCDomainParameters.getN(), this.random);
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger), this.key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPoint))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

