/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.ec;

import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.ec.ECDecryptor;
import org.bouncycastleDJ.crypto.ec.ECPair;
import org.bouncycastleDJ.crypto.params.ECPrivateKeyParameters;
import org.bouncycastleDJ.math.ec.ECAlgorithms;
import org.bouncycastleDJ.math.ec.ECCurve;
import org.bouncycastleDJ.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public ECPoint decrypt(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve eCCurve = this.key.getParameters().getCurve();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, eCPair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(eCCurve, eCPair.getY()).subtract(eCPoint).normalize();
    }
}

