/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastleDJ.crypto.params.ECDHUPrivateParameters;
import org.bouncycastleDJ.crypto.params.ECDHUPublicParameters;
import org.bouncycastleDJ.util.Arrays;
import org.bouncycastleDJ.util.BigIntegers;

public class ECDHCUnifiedAgreement {
    private ECDHUPrivateParameters privParams;

    public void init(CipherParameters cipherParameters) {
        this.privParams = (ECDHUPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        ECDHUPublicParameters eCDHUPublicParameters = (ECDHUPublicParameters)cipherParameters;
        ECDHCBasicAgreement eCDHCBasicAgreement = new ECDHCBasicAgreement();
        ECDHCBasicAgreement eCDHCBasicAgreement2 = new ECDHCBasicAgreement();
        eCDHCBasicAgreement.init(this.privParams.getStaticPrivateKey());
        BigInteger bigInteger = eCDHCBasicAgreement.calculateAgreement(eCDHUPublicParameters.getStaticPublicKey());
        eCDHCBasicAgreement2.init(this.privParams.getEphemeralPrivateKey());
        BigInteger bigInteger2 = eCDHCBasicAgreement2.calculateAgreement(eCDHUPublicParameters.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger2), BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger));
    }
}

