/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.StagedAgreement;
import org.bouncycastleDJ.crypto.params.AsymmetricKeyParameter;
import org.bouncycastleDJ.crypto.params.ECDomainParameters;
import org.bouncycastleDJ.crypto.params.ECPrivateKeyParameters;
import org.bouncycastleDJ.crypto.params.ECPublicKeyParameters;
import org.bouncycastleDJ.math.ec.ECAlgorithms;
import org.bouncycastleDJ.math.ec.ECPoint;

public class ECDHCStagedAgreement
implements StagedAgreement {
    ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public AsymmetricKeyParameter calculateStage(CipherParameters cipherParameters) {
        ECPoint eCPoint = this.calculateNextPoint((ECPublicKeyParameters)cipherParameters);
        return new ECPublicKeyParameters(eCPoint, this.key.getParameters());
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPoint eCPoint = this.calculateNextPoint((ECPublicKeyParameters)cipherParameters);
        return eCPoint.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateNextPoint(ECPublicKeyParameters eCPublicKeyParameters) {
        ECPublicKeyParameters eCPublicKeyParameters2 = eCPublicKeyParameters;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters2.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.key.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters2.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return eCPoint2;
    }
}

