/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cms.jcajce;

import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.RecipientOperator;
import org.bouncycastleDJ.cms.jcajce.JceKeyTransRecipient;
import org.bouncycastleDJ.jcajce.io.MacOutputStream;
import org.bouncycastleDJ.operator.GenericKey;
import org.bouncycastleDJ.operator.MacCalculator;
import org.bouncycastleDJ.operator.jcajce.JceGenericKey;

public class JceKeyTransAuthenticatedRecipient
extends JceKeyTransRecipient {
    public JceKeyTransAuthenticatedRecipient(PrivateKey privateKey) {
        super(privateKey);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Mac mac = this.contentHelper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

