/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cms.bc;

import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.KeyTransRecipient;
import org.bouncycastleDJ.cms.bc.CMSUtils;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.params.AsymmetricKeyParameter;
import org.bouncycastleDJ.operator.OperatorException;
import org.bouncycastleDJ.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.recipientKey = asymmetricKeyParameter;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper bcRSAAsymmetricKeyUnwrapper = new BcRSAAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return CMSUtils.getBcKey(bcRSAAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

