/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cms;

import org.bouncycastleDJ.asn1.ASN1OctetString;
import org.bouncycastleDJ.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastleDJ.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastleDJ.asn1.cms.RecipientIdentifier;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.cms.AuthAttributesProvider;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.CMSSecureReadable;
import org.bouncycastleDJ.cms.KeyTransRecipient;
import org.bouncycastleDJ.cms.KeyTransRecipientId;
import org.bouncycastleDJ.cms.Recipient;
import org.bouncycastleDJ.cms.RecipientInformation;
import org.bouncycastleDJ.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

