/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cms;

import org.bouncycastleDJ.asn1.DEROctetString;
import org.bouncycastleDJ.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastleDJ.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastleDJ.asn1.cms.RecipientIdentifier;
import org.bouncycastleDJ.asn1.cms.RecipientInfo;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.RecipientInfoGenerator;
import org.bouncycastleDJ.operator.AsymmetricKeyWrapper;
import org.bouncycastleDJ.operator.GenericKey;
import org.bouncycastleDJ.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = asymmetricKeyWrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] byArray, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = asymmetricKeyWrapper;
    }

    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(byArray)));
    }
}

