/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cms;

import java.io.IOException;
import org.bouncycastleDJ.asn1.cms.KEKIdentifier;
import org.bouncycastleDJ.asn1.cms.KEKRecipientInfo;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.cms.AuthAttributesProvider;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.CMSSecureReadable;
import org.bouncycastleDJ.cms.KEKRecipient;
import org.bouncycastleDJ.cms.KEKRecipientId;
import org.bouncycastleDJ.cms.Recipient;
import org.bouncycastleDJ.cms.RecipientInformation;
import org.bouncycastleDJ.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

